// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Provisioning status of Custom Https of the frontendEndpoint. </summary>
    public readonly partial struct FrontendEndpointCustomHttpsProvisioningState : IEquatable<FrontendEndpointCustomHttpsProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontendEndpointCustomHttpsProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontendEndpointCustomHttpsProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnablingValue = "Enabling";
        private const string EnabledValue = "Enabled";
        private const string DisablingValue = "Disabling";
        private const string DisabledValue = "Disabled";
        private const string FailedValue = "Failed";

        /// <summary> Enabling. </summary>
        public static FrontendEndpointCustomHttpsProvisioningState Enabling { get; } = new FrontendEndpointCustomHttpsProvisioningState(EnablingValue);
        /// <summary> Enabled. </summary>
        public static FrontendEndpointCustomHttpsProvisioningState Enabled { get; } = new FrontendEndpointCustomHttpsProvisioningState(EnabledValue);
        /// <summary> Disabling. </summary>
        public static FrontendEndpointCustomHttpsProvisioningState Disabling { get; } = new FrontendEndpointCustomHttpsProvisioningState(DisablingValue);
        /// <summary> Disabled. </summary>
        public static FrontendEndpointCustomHttpsProvisioningState Disabled { get; } = new FrontendEndpointCustomHttpsProvisioningState(DisabledValue);
        /// <summary> Failed. </summary>
        public static FrontendEndpointCustomHttpsProvisioningState Failed { get; } = new FrontendEndpointCustomHttpsProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="FrontendEndpointCustomHttpsProvisioningState"/> values are the same. </summary>
        public static bool operator ==(FrontendEndpointCustomHttpsProvisioningState left, FrontendEndpointCustomHttpsProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontendEndpointCustomHttpsProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(FrontendEndpointCustomHttpsProvisioningState left, FrontendEndpointCustomHttpsProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontendEndpointCustomHttpsProvisioningState"/>. </summary>
        public static implicit operator FrontendEndpointCustomHttpsProvisioningState(string value) => new FrontendEndpointCustomHttpsProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontendEndpointCustomHttpsProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontendEndpointCustomHttpsProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
