// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.FrontDoor.Models
{
    public partial class FrontDoorWebApplicationFirewallPolicySettings : IUtf8JsonSerializable, IJsonModel<FrontDoorWebApplicationFirewallPolicySettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FrontDoorWebApplicationFirewallPolicySettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FrontDoorWebApplicationFirewallPolicySettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FrontDoorWebApplicationFirewallPolicySettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FrontDoorWebApplicationFirewallPolicySettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(EnabledState))
            {
                writer.WritePropertyName("enabledState"u8);
                writer.WriteStringValue(EnabledState.Value.ToString());
            }
            if (Optional.IsDefined(Mode))
            {
                writer.WritePropertyName("mode"u8);
                writer.WriteStringValue(Mode.Value.ToString());
            }
            if (Optional.IsDefined(RedirectUri))
            {
                writer.WritePropertyName("redirectUrl"u8);
                writer.WriteStringValue(RedirectUri.AbsoluteUri);
            }
            if (Optional.IsDefined(CustomBlockResponseStatusCode))
            {
                writer.WritePropertyName("customBlockResponseStatusCode"u8);
                writer.WriteNumberValue(CustomBlockResponseStatusCode.Value);
            }
            if (Optional.IsDefined(CustomBlockResponseBody))
            {
                writer.WritePropertyName("customBlockResponseBody"u8);
                writer.WriteStringValue(CustomBlockResponseBody);
            }
            if (Optional.IsDefined(RequestBodyCheck))
            {
                writer.WritePropertyName("requestBodyCheck"u8);
                writer.WriteStringValue(RequestBodyCheck.Value.ToString());
            }
            if (Optional.IsDefined(JavascriptChallengeExpirationInMinutes))
            {
                writer.WritePropertyName("javascriptChallengeExpirationInMinutes"u8);
                writer.WriteNumberValue(JavascriptChallengeExpirationInMinutes.Value);
            }
            writer.WritePropertyName("logScrubbing"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (Optional.IsCollectionDefined(ScrubbingRules))
            {
                writer.WritePropertyName("scrubbingRules"u8);
                writer.WriteStartArray();
                foreach (var item in ScrubbingRules)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FrontDoorWebApplicationFirewallPolicySettings IJsonModel<FrontDoorWebApplicationFirewallPolicySettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FrontDoorWebApplicationFirewallPolicySettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FrontDoorWebApplicationFirewallPolicySettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFrontDoorWebApplicationFirewallPolicySettings(document.RootElement, options);
        }

        internal static FrontDoorWebApplicationFirewallPolicySettings DeserializeFrontDoorWebApplicationFirewallPolicySettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            PolicyEnabledState? enabledState = default;
            FrontDoorWebApplicationFirewallPolicyMode? mode = default;
            Uri redirectUrl = default;
            int? customBlockResponseStatusCode = default;
            string customBlockResponseBody = default;
            PolicyRequestBodyCheck? requestBodyCheck = default;
            int? javascriptChallengeExpirationInMinutes = default;
            WebApplicationFirewallScrubbingState? state = default;
            IList<WebApplicationFirewallScrubbingRules> scrubbingRules = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("enabledState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enabledState = new PolicyEnabledState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("mode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    mode = new FrontDoorWebApplicationFirewallPolicyMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("redirectUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    redirectUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("customBlockResponseStatusCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    customBlockResponseStatusCode = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("customBlockResponseBody"u8))
                {
                    customBlockResponseBody = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("requestBodyCheck"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    requestBodyCheck = new PolicyRequestBodyCheck(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("javascriptChallengeExpirationInMinutes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    javascriptChallengeExpirationInMinutes = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("logScrubbing"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("state"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            state = new WebApplicationFirewallScrubbingState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("scrubbingRules"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<WebApplicationFirewallScrubbingRules> array = new List<WebApplicationFirewallScrubbingRules>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(WebApplicationFirewallScrubbingRules.DeserializeWebApplicationFirewallScrubbingRules(item, options));
                            }
                            scrubbingRules = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FrontDoorWebApplicationFirewallPolicySettings(
                enabledState,
                mode,
                redirectUrl,
                customBlockResponseStatusCode,
                customBlockResponseBody,
                requestBodyCheck,
                javascriptChallengeExpirationInMinutes,
                state,
                scrubbingRules ?? new ChangeTrackingList<WebApplicationFirewallScrubbingRules>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<FrontDoorWebApplicationFirewallPolicySettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FrontDoorWebApplicationFirewallPolicySettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FrontDoorWebApplicationFirewallPolicySettings)} does not support writing '{options.Format}' format.");
            }
        }

        FrontDoorWebApplicationFirewallPolicySettings IPersistableModel<FrontDoorWebApplicationFirewallPolicySettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FrontDoorWebApplicationFirewallPolicySettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFrontDoorWebApplicationFirewallPolicySettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FrontDoorWebApplicationFirewallPolicySettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FrontDoorWebApplicationFirewallPolicySettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
