// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Describes if it is in detection mode or prevention mode at policy level. </summary>
    public readonly partial struct FrontDoorWebApplicationFirewallPolicyMode : IEquatable<FrontDoorWebApplicationFirewallPolicyMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorWebApplicationFirewallPolicyMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorWebApplicationFirewallPolicyMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PreventionValue = "Prevention";
        private const string DetectionValue = "Detection";

        /// <summary> Prevention. </summary>
        public static FrontDoorWebApplicationFirewallPolicyMode Prevention { get; } = new FrontDoorWebApplicationFirewallPolicyMode(PreventionValue);
        /// <summary> Detection. </summary>
        public static FrontDoorWebApplicationFirewallPolicyMode Detection { get; } = new FrontDoorWebApplicationFirewallPolicyMode(DetectionValue);
        /// <summary> Determines if two <see cref="FrontDoorWebApplicationFirewallPolicyMode"/> values are the same. </summary>
        public static bool operator ==(FrontDoorWebApplicationFirewallPolicyMode left, FrontDoorWebApplicationFirewallPolicyMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorWebApplicationFirewallPolicyMode"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorWebApplicationFirewallPolicyMode left, FrontDoorWebApplicationFirewallPolicyMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorWebApplicationFirewallPolicyMode"/>. </summary>
        public static implicit operator FrontDoorWebApplicationFirewallPolicyMode(string value) => new FrontDoorWebApplicationFirewallPolicyMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorWebApplicationFirewallPolicyMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorWebApplicationFirewallPolicyMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
