// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Describes the supported variable for group by. </summary>
    public readonly partial struct FrontDoorWebApplicationFirewallPolicyGroupByVariableName : IEquatable<FrontDoorWebApplicationFirewallPolicyGroupByVariableName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorWebApplicationFirewallPolicyGroupByVariableName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorWebApplicationFirewallPolicyGroupByVariableName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SocketAddrValue = "SocketAddr";
        private const string GeoLocationValue = "GeoLocation";
        private const string NoneValue = "None";

        /// <summary> SocketAddr. </summary>
        public static FrontDoorWebApplicationFirewallPolicyGroupByVariableName SocketAddr { get; } = new FrontDoorWebApplicationFirewallPolicyGroupByVariableName(SocketAddrValue);
        /// <summary> GeoLocation. </summary>
        public static FrontDoorWebApplicationFirewallPolicyGroupByVariableName GeoLocation { get; } = new FrontDoorWebApplicationFirewallPolicyGroupByVariableName(GeoLocationValue);
        /// <summary> None. </summary>
        public static FrontDoorWebApplicationFirewallPolicyGroupByVariableName None { get; } = new FrontDoorWebApplicationFirewallPolicyGroupByVariableName(NoneValue);
        /// <summary> Determines if two <see cref="FrontDoorWebApplicationFirewallPolicyGroupByVariableName"/> values are the same. </summary>
        public static bool operator ==(FrontDoorWebApplicationFirewallPolicyGroupByVariableName left, FrontDoorWebApplicationFirewallPolicyGroupByVariableName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorWebApplicationFirewallPolicyGroupByVariableName"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorWebApplicationFirewallPolicyGroupByVariableName left, FrontDoorWebApplicationFirewallPolicyGroupByVariableName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorWebApplicationFirewallPolicyGroupByVariableName"/>. </summary>
        public static implicit operator FrontDoorWebApplicationFirewallPolicyGroupByVariableName(string value) => new FrontDoorWebApplicationFirewallPolicyGroupByVariableName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorWebApplicationFirewallPolicyGroupByVariableName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorWebApplicationFirewallPolicyGroupByVariableName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
