// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Describes the variables available to group the rate limit requests. </summary>
    public partial class FrontDoorWebApplicationFirewallPolicyGroupByVariable
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FrontDoorWebApplicationFirewallPolicyGroupByVariable"/>. </summary>
        /// <param name="variableName"> Describes the supported variable for group by. </param>
        public FrontDoorWebApplicationFirewallPolicyGroupByVariable(FrontDoorWebApplicationFirewallPolicyGroupByVariableName variableName)
        {
            VariableName = variableName;
        }

        /// <summary> Initializes a new instance of <see cref="FrontDoorWebApplicationFirewallPolicyGroupByVariable"/>. </summary>
        /// <param name="variableName"> Describes the supported variable for group by. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FrontDoorWebApplicationFirewallPolicyGroupByVariable(FrontDoorWebApplicationFirewallPolicyGroupByVariableName variableName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VariableName = variableName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FrontDoorWebApplicationFirewallPolicyGroupByVariable"/> for deserialization. </summary>
        internal FrontDoorWebApplicationFirewallPolicyGroupByVariable()
        {
        }

        /// <summary> Describes the supported variable for group by. </summary>
        public FrontDoorWebApplicationFirewallPolicyGroupByVariableName VariableName { get; set; }
    }
}
