// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> The FrontDoorTimeSeriesAggregationInterval. </summary>
    public readonly partial struct FrontDoorTimeSeriesAggregationInterval : IEquatable<FrontDoorTimeSeriesAggregationInterval>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorTimeSeriesAggregationInterval"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorTimeSeriesAggregationInterval(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HourlyValue = "Hourly";
        private const string DailyValue = "Daily";

        /// <summary> Hourly. </summary>
        public static FrontDoorTimeSeriesAggregationInterval Hourly { get; } = new FrontDoorTimeSeriesAggregationInterval(HourlyValue);
        /// <summary> Daily. </summary>
        public static FrontDoorTimeSeriesAggregationInterval Daily { get; } = new FrontDoorTimeSeriesAggregationInterval(DailyValue);
        /// <summary> Determines if two <see cref="FrontDoorTimeSeriesAggregationInterval"/> values are the same. </summary>
        public static bool operator ==(FrontDoorTimeSeriesAggregationInterval left, FrontDoorTimeSeriesAggregationInterval right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorTimeSeriesAggregationInterval"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorTimeSeriesAggregationInterval left, FrontDoorTimeSeriesAggregationInterval right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorTimeSeriesAggregationInterval"/>. </summary>
        public static implicit operator FrontDoorTimeSeriesAggregationInterval(string value) => new FrontDoorTimeSeriesAggregationInterval(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorTimeSeriesAggregationInterval other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorTimeSeriesAggregationInterval other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
