// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Name of the pricing tier. </summary>
    public readonly partial struct FrontDoorSkuName : IEquatable<FrontDoorSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ClassicAzureFrontDoorValue = "Classic_AzureFrontDoor";
        private const string StandardAzureFrontDoorValue = "Standard_AzureFrontDoor";
        private const string PremiumAzureFrontDoorValue = "Premium_AzureFrontDoor";

        /// <summary> Classic_AzureFrontDoor. </summary>
        public static FrontDoorSkuName ClassicAzureFrontDoor { get; } = new FrontDoorSkuName(ClassicAzureFrontDoorValue);
        /// <summary> Standard_AzureFrontDoor. </summary>
        public static FrontDoorSkuName StandardAzureFrontDoor { get; } = new FrontDoorSkuName(StandardAzureFrontDoorValue);
        /// <summary> Premium_AzureFrontDoor. </summary>
        public static FrontDoorSkuName PremiumAzureFrontDoor { get; } = new FrontDoorSkuName(PremiumAzureFrontDoorValue);
        /// <summary> Determines if two <see cref="FrontDoorSkuName"/> values are the same. </summary>
        public static bool operator ==(FrontDoorSkuName left, FrontDoorSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorSkuName"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorSkuName left, FrontDoorSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorSkuName"/>. </summary>
        public static implicit operator FrontDoorSkuName(string value) => new FrontDoorSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
