// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.FrontDoor.Models
{
    internal static partial class FrontDoorResourceTypeExtensions
    {
        public static string ToSerialString(this FrontDoorResourceType value) => value switch
        {
            FrontDoorResourceType.MicrosoftNetworkFrontDoors => "Microsoft.Network/frontDoors",
            FrontDoorResourceType.MicrosoftNetworkFrontDoorsFrontendEndpoints => "Microsoft.Network/frontDoors/frontendEndpoints",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FrontDoorResourceType value.")
        };

        public static FrontDoorResourceType ToFrontDoorResourceType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Microsoft.Network/frontDoors")) return FrontDoorResourceType.MicrosoftNetworkFrontDoors;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Microsoft.Network/frontDoors/frontendEndpoints")) return FrontDoorResourceType.MicrosoftNetworkFrontDoorsFrontendEndpoints;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FrontDoorResourceType value.");
        }
    }
}
