// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Resource status of the Front Door or Front Door SubResource. </summary>
    public readonly partial struct FrontDoorResourceState : IEquatable<FrontDoorResourceState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorResourceState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorResourceState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string EnablingValue = "Enabling";
        private const string EnabledValue = "Enabled";
        private const string DisablingValue = "Disabling";
        private const string DisabledValue = "Disabled";
        private const string DeletingValue = "Deleting";
        private const string MigratingValue = "Migrating";
        private const string MigratedValue = "Migrated";

        /// <summary> Creating. </summary>
        public static FrontDoorResourceState Creating { get; } = new FrontDoorResourceState(CreatingValue);
        /// <summary> Enabling. </summary>
        public static FrontDoorResourceState Enabling { get; } = new FrontDoorResourceState(EnablingValue);
        /// <summary> Enabled. </summary>
        public static FrontDoorResourceState Enabled { get; } = new FrontDoorResourceState(EnabledValue);
        /// <summary> Disabling. </summary>
        public static FrontDoorResourceState Disabling { get; } = new FrontDoorResourceState(DisablingValue);
        /// <summary> Disabled. </summary>
        public static FrontDoorResourceState Disabled { get; } = new FrontDoorResourceState(DisabledValue);
        /// <summary> Deleting. </summary>
        public static FrontDoorResourceState Deleting { get; } = new FrontDoorResourceState(DeletingValue);
        /// <summary> Migrating. </summary>
        public static FrontDoorResourceState Migrating { get; } = new FrontDoorResourceState(MigratingValue);
        /// <summary> Migrated. </summary>
        public static FrontDoorResourceState Migrated { get; } = new FrontDoorResourceState(MigratedValue);
        /// <summary> Determines if two <see cref="FrontDoorResourceState"/> values are the same. </summary>
        public static bool operator ==(FrontDoorResourceState left, FrontDoorResourceState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorResourceState"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorResourceState left, FrontDoorResourceState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorResourceState"/>. </summary>
        public static implicit operator FrontDoorResourceState(string value) => new FrontDoorResourceState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorResourceState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorResourceState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
