// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> The redirect type the rule will use when redirecting traffic. </summary>
    public readonly partial struct FrontDoorRedirectType : IEquatable<FrontDoorRedirectType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorRedirectType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorRedirectType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MovedValue = "Moved";
        private const string FoundValue = "Found";
        private const string TemporaryRedirectValue = "TemporaryRedirect";
        private const string PermanentRedirectValue = "PermanentRedirect";

        /// <summary> Moved. </summary>
        public static FrontDoorRedirectType Moved { get; } = new FrontDoorRedirectType(MovedValue);
        /// <summary> Found. </summary>
        public static FrontDoorRedirectType Found { get; } = new FrontDoorRedirectType(FoundValue);
        /// <summary> TemporaryRedirect. </summary>
        public static FrontDoorRedirectType TemporaryRedirect { get; } = new FrontDoorRedirectType(TemporaryRedirectValue);
        /// <summary> PermanentRedirect. </summary>
        public static FrontDoorRedirectType PermanentRedirect { get; } = new FrontDoorRedirectType(PermanentRedirectValue);
        /// <summary> Determines if two <see cref="FrontDoorRedirectType"/> values are the same. </summary>
        public static bool operator ==(FrontDoorRedirectType left, FrontDoorRedirectType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorRedirectType"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorRedirectType left, FrontDoorRedirectType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorRedirectType"/>. </summary>
        public static implicit operator FrontDoorRedirectType(string value) => new FrontDoorRedirectType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorRedirectType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorRedirectType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
