// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> The protocol of the destination to where the traffic is redirected. </summary>
    public readonly partial struct FrontDoorRedirectProtocol : IEquatable<FrontDoorRedirectProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorRedirectProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorRedirectProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HttpOnlyValue = "HttpOnly";
        private const string HttpsOnlyValue = "HttpsOnly";
        private const string MatchRequestValue = "MatchRequest";

        /// <summary> HttpOnly. </summary>
        public static FrontDoorRedirectProtocol HttpOnly { get; } = new FrontDoorRedirectProtocol(HttpOnlyValue);
        /// <summary> HttpsOnly. </summary>
        public static FrontDoorRedirectProtocol HttpsOnly { get; } = new FrontDoorRedirectProtocol(HttpsOnlyValue);
        /// <summary> MatchRequest. </summary>
        public static FrontDoorRedirectProtocol MatchRequest { get; } = new FrontDoorRedirectProtocol(MatchRequestValue);
        /// <summary> Determines if two <see cref="FrontDoorRedirectProtocol"/> values are the same. </summary>
        public static bool operator ==(FrontDoorRedirectProtocol left, FrontDoorRedirectProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorRedirectProtocol"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorRedirectProtocol left, FrontDoorRedirectProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorRedirectProtocol"/>. </summary>
        public static implicit operator FrontDoorRedirectProtocol(string value) => new FrontDoorRedirectProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorRedirectProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorRedirectProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
