// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Treatment of URL query terms when forming the cache key. </summary>
    public readonly partial struct FrontDoorQuery : IEquatable<FrontDoorQuery>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorQuery"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorQuery(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StripNoneValue = "StripNone";
        private const string StripAllValue = "StripAll";
        private const string StripOnlyValue = "StripOnly";
        private const string StripAllExceptValue = "StripAllExcept";

        /// <summary> StripNone. </summary>
        public static FrontDoorQuery StripNone { get; } = new FrontDoorQuery(StripNoneValue);
        /// <summary> StripAll. </summary>
        public static FrontDoorQuery StripAll { get; } = new FrontDoorQuery(StripAllValue);
        /// <summary> StripOnly. </summary>
        public static FrontDoorQuery StripOnly { get; } = new FrontDoorQuery(StripOnlyValue);
        /// <summary> StripAllExcept. </summary>
        public static FrontDoorQuery StripAllExcept { get; } = new FrontDoorQuery(StripAllExceptValue);
        /// <summary> Determines if two <see cref="FrontDoorQuery"/> values are the same. </summary>
        public static bool operator ==(FrontDoorQuery left, FrontDoorQuery right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorQuery"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorQuery left, FrontDoorQuery right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorQuery"/>. </summary>
        public static implicit operator FrontDoorQuery(string value) => new FrontDoorQuery(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorQuery other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorQuery other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
