// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Accepted protocol schemes. </summary>
    public readonly partial struct FrontDoorProtocol : IEquatable<FrontDoorProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HttpValue = "Http";
        private const string HttpsValue = "Https";

        /// <summary> Http. </summary>
        public static FrontDoorProtocol Http { get; } = new FrontDoorProtocol(HttpValue);
        /// <summary> Https. </summary>
        public static FrontDoorProtocol Https { get; } = new FrontDoorProtocol(HttpsValue);
        /// <summary> Determines if two <see cref="FrontDoorProtocol"/> values are the same. </summary>
        public static bool operator ==(FrontDoorProtocol left, FrontDoorProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorProtocol"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorProtocol left, FrontDoorProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorProtocol"/>. </summary>
        public static implicit operator FrontDoorProtocol(string value) => new FrontDoorProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
