// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Load balancing settings for a backend pool. </summary>
    public partial class FrontDoorHealthProbeSettingsData : FrontDoorResourceData
    {
        /// <summary> Initializes a new instance of <see cref="FrontDoorHealthProbeSettingsData"/>. </summary>
        public FrontDoorHealthProbeSettingsData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FrontDoorHealthProbeSettingsData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="path"> The path to use for the health probe. Default is /. </param>
        /// <param name="protocol"> Protocol scheme to use for this probe. </param>
        /// <param name="intervalInSeconds"> The number of seconds between health probes. </param>
        /// <param name="healthProbeMethod"> Configures which HTTP method to use to probe the backends defined under backendPools. </param>
        /// <param name="enabledState"> Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool. </param>
        /// <param name="resourceState"> Resource status. </param>
        internal FrontDoorHealthProbeSettingsData(ResourceIdentifier id, string name, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string path, FrontDoorProtocol? protocol, int? intervalInSeconds, FrontDoorHealthProbeMethod? healthProbeMethod, HealthProbeEnabled? enabledState, FrontDoorResourceState? resourceState) : base(id, name, resourceType, serializedAdditionalRawData)
        {
            Path = path;
            Protocol = protocol;
            IntervalInSeconds = intervalInSeconds;
            HealthProbeMethod = healthProbeMethod;
            EnabledState = enabledState;
            ResourceState = resourceState;
        }

        /// <summary> The path to use for the health probe. Default is /. </summary>
        public string Path { get; set; }
        /// <summary> Protocol scheme to use for this probe. </summary>
        public FrontDoorProtocol? Protocol { get; set; }
        /// <summary> The number of seconds between health probes. </summary>
        public int? IntervalInSeconds { get; set; }
        /// <summary> Configures which HTTP method to use to probe the backends defined under backendPools. </summary>
        public FrontDoorHealthProbeMethod? HealthProbeMethod { get; set; }
        /// <summary> Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool. </summary>
        public HealthProbeEnabled? EnabledState { get; set; }
        /// <summary> Resource status. </summary>
        public FrontDoorResourceState? ResourceState { get; }
    }
}
