// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> The state of the Experiment. </summary>
    public readonly partial struct FrontDoorExperimentState : IEquatable<FrontDoorExperimentState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorExperimentState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorExperimentState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static FrontDoorExperimentState Enabled { get; } = new FrontDoorExperimentState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static FrontDoorExperimentState Disabled { get; } = new FrontDoorExperimentState(DisabledValue);
        /// <summary> Determines if two <see cref="FrontDoorExperimentState"/> values are the same. </summary>
        public static bool operator ==(FrontDoorExperimentState left, FrontDoorExperimentState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorExperimentState"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorExperimentState left, FrontDoorExperimentState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorExperimentState"/>. </summary>
        public static implicit operator FrontDoorExperimentState(string value) => new FrontDoorExperimentState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorExperimentState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorExperimentState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
