// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> The type of endpoint. </summary>
    public readonly partial struct FrontDoorEndpointType : IEquatable<FrontDoorEndpointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FrontDoorEndpointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FrontDoorEndpointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureFrontDoorValue = "AFD";
        private const string AzureRegionValue = "AzureRegion";
        private const string CdnValue = "CDN";
        private const string AzureTrafficManagerValue = "ATM";

        /// <summary> AFD. </summary>
        public static FrontDoorEndpointType AzureFrontDoor { get; } = new FrontDoorEndpointType(AzureFrontDoorValue);
        /// <summary> AzureRegion. </summary>
        public static FrontDoorEndpointType AzureRegion { get; } = new FrontDoorEndpointType(AzureRegionValue);
        /// <summary> CDN. </summary>
        public static FrontDoorEndpointType Cdn { get; } = new FrontDoorEndpointType(CdnValue);
        /// <summary> ATM. </summary>
        public static FrontDoorEndpointType AzureTrafficManager { get; } = new FrontDoorEndpointType(AzureTrafficManagerValue);
        /// <summary> Determines if two <see cref="FrontDoorEndpointType"/> values are the same. </summary>
        public static bool operator ==(FrontDoorEndpointType left, FrontDoorEndpointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FrontDoorEndpointType"/> values are not the same. </summary>
        public static bool operator !=(FrontDoorEndpointType left, FrontDoorEndpointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FrontDoorEndpointType"/>. </summary>
        public static implicit operator FrontDoorEndpointType(string value) => new FrontDoorEndpointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FrontDoorEndpointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FrontDoorEndpointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
