// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests. </summary>
    public readonly partial struct EnforceCertificateNameCheckEnabledState : IEquatable<EnforceCertificateNameCheckEnabledState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EnforceCertificateNameCheckEnabledState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EnforceCertificateNameCheckEnabledState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static EnforceCertificateNameCheckEnabledState Enabled { get; } = new EnforceCertificateNameCheckEnabledState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static EnforceCertificateNameCheckEnabledState Disabled { get; } = new EnforceCertificateNameCheckEnabledState(DisabledValue);
        /// <summary> Determines if two <see cref="EnforceCertificateNameCheckEnabledState"/> values are the same. </summary>
        public static bool operator ==(EnforceCertificateNameCheckEnabledState left, EnforceCertificateNameCheckEnabledState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EnforceCertificateNameCheckEnabledState"/> values are not the same. </summary>
        public static bool operator !=(EnforceCertificateNameCheckEnabledState left, EnforceCertificateNameCheckEnabledState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EnforceCertificateNameCheckEnabledState"/>. </summary>
        public static implicit operator EnforceCertificateNameCheckEnabledState(string value) => new EnforceCertificateNameCheckEnabledState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EnforceCertificateNameCheckEnabledState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EnforceCertificateNameCheckEnabledState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
