// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Https settings for a domain. </summary>
    public partial class CustomHttpsConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CustomHttpsConfiguration"/>. </summary>
        /// <param name="certificateSource"> Defines the source of the SSL certificate. </param>
        /// <param name="protocolType"> Defines the TLS extension protocol that is used for secure delivery. </param>
        /// <param name="minimumTlsVersion"> The minimum TLS version required from the clients to establish an SSL handshake with Front Door. </param>
        public CustomHttpsConfiguration(FrontDoorCertificateSource certificateSource, FrontDoorTlsProtocolType protocolType, FrontDoorRequiredMinimumTlsVersion minimumTlsVersion)
        {
            CertificateSource = certificateSource;
            ProtocolType = protocolType;
            MinimumTlsVersion = minimumTlsVersion;
        }

        /// <summary> Initializes a new instance of <see cref="CustomHttpsConfiguration"/>. </summary>
        /// <param name="certificateSource"> Defines the source of the SSL certificate. </param>
        /// <param name="protocolType"> Defines the TLS extension protocol that is used for secure delivery. </param>
        /// <param name="minimumTlsVersion"> The minimum TLS version required from the clients to establish an SSL handshake with Front Door. </param>
        /// <param name="certificateType"> Defines the type of the certificate used for secure connections to a frontendEndpoint. </param>
        /// <param name="vault"> The Key Vault containing the SSL certificate. </param>
        /// <param name="secretName"> The name of the Key Vault secret representing the full certificate PFX. </param>
        /// <param name="secretVersion"> The version of the Key Vault secret representing the full certificate PFX. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CustomHttpsConfiguration(FrontDoorCertificateSource certificateSource, FrontDoorTlsProtocolType protocolType, FrontDoorRequiredMinimumTlsVersion minimumTlsVersion, FrontDoorEndpointConnectionCertificateType? certificateType, WritableSubResource vault, string secretName, string secretVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CertificateSource = certificateSource;
            ProtocolType = protocolType;
            MinimumTlsVersion = minimumTlsVersion;
            CertificateType = certificateType;
            Vault = vault;
            SecretName = secretName;
            SecretVersion = secretVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CustomHttpsConfiguration"/> for deserialization. </summary>
        internal CustomHttpsConfiguration()
        {
        }

        /// <summary> Defines the source of the SSL certificate. </summary>
        public FrontDoorCertificateSource CertificateSource { get; set; }
        /// <summary> Defines the TLS extension protocol that is used for secure delivery. </summary>
        public FrontDoorTlsProtocolType ProtocolType { get; set; }
        /// <summary> The minimum TLS version required from the clients to establish an SSL handshake with Front Door. </summary>
        public FrontDoorRequiredMinimumTlsVersion MinimumTlsVersion { get; set; }
        /// <summary> Defines the type of the certificate used for secure connections to a frontendEndpoint. </summary>
        public FrontDoorEndpointConnectionCertificateType? CertificateType { get; set; }
        /// <summary> The Key Vault containing the SSL certificate. </summary>
        internal WritableSubResource Vault { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier VaultId
        {
            get => Vault is null ? default : Vault.Id;
            set
            {
                if (Vault is null)
                    Vault = new WritableSubResource();
                Vault.Id = value;
            }
        }

        /// <summary> The name of the Key Vault secret representing the full certificate PFX. </summary>
        public string SecretName { get; set; }
        /// <summary> The version of the Key Vault secret representing the full certificate PFX. </summary>
        public string SecretVersion { get; set; }
    }
}
