// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'. </summary>
    public readonly partial struct BackendEnabledState : IEquatable<BackendEnabledState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackendEnabledState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackendEnabledState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static BackendEnabledState Enabled { get; } = new BackendEnabledState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static BackendEnabledState Disabled { get; } = new BackendEnabledState(DisabledValue);
        /// <summary> Determines if two <see cref="BackendEnabledState"/> values are the same. </summary>
        public static bool operator ==(BackendEnabledState left, BackendEnabledState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackendEnabledState"/> values are not the same. </summary>
        public static bool operator !=(BackendEnabledState left, BackendEnabledState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackendEnabledState"/>. </summary>
        public static implicit operator BackendEnabledState(string value) => new BackendEnabledState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackendEnabledState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackendEnabledState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
