// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.FrontDoor
{
    internal class FrontDoorOperationSource : IOperationSource<FrontDoorResource>
    {
        private readonly ArmClient _client;

        internal FrontDoorOperationSource(ArmClient client)
        {
            _client = client;
        }

        FrontDoorResource IOperationSource<FrontDoorResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = FrontDoorData.DeserializeFrontDoorData(document.RootElement);
            return new FrontDoorResource(_client, data);
        }

        async ValueTask<FrontDoorResource> IOperationSource<FrontDoorResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = FrontDoorData.DeserializeFrontDoorData(document.RootElement);
            return new FrontDoorResource(_client, data);
        }
    }
}
