// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.FrontDoor
{
    internal class FrontDoorNetworkExperimentProfileOperationSource : IOperationSource<FrontDoorNetworkExperimentProfileResource>
    {
        private readonly ArmClient _client;

        internal FrontDoorNetworkExperimentProfileOperationSource(ArmClient client)
        {
            _client = client;
        }

        FrontDoorNetworkExperimentProfileResource IOperationSource<FrontDoorNetworkExperimentProfileResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = FrontDoorNetworkExperimentProfileData.DeserializeFrontDoorNetworkExperimentProfileData(document.RootElement);
            return new FrontDoorNetworkExperimentProfileResource(_client, data);
        }

        async ValueTask<FrontDoorNetworkExperimentProfileResource> IOperationSource<FrontDoorNetworkExperimentProfileResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = FrontDoorNetworkExperimentProfileData.DeserializeFrontDoorNetworkExperimentProfileData(document.RootElement);
            return new FrontDoorNetworkExperimentProfileResource(_client, data);
        }
    }
}
