// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.FrontDoor.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.FrontDoor
{
    public partial class FrontendEndpointData : IUtf8JsonSerializable, IJsonModel<FrontendEndpointData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FrontendEndpointData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FrontendEndpointData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FrontendEndpointData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FrontendEndpointData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(HostName))
            {
                writer.WritePropertyName("hostName"u8);
                writer.WriteStringValue(HostName);
            }
            if (Optional.IsDefined(SessionAffinityEnabledState))
            {
                writer.WritePropertyName("sessionAffinityEnabledState"u8);
                writer.WriteStringValue(SessionAffinityEnabledState.Value.ToString());
            }
            if (Optional.IsDefined(SessionAffinityTtlInSeconds))
            {
                writer.WritePropertyName("sessionAffinityTtlSeconds"u8);
                writer.WriteNumberValue(SessionAffinityTtlInSeconds.Value);
            }
            if (Optional.IsDefined(WebApplicationFirewallPolicyLink))
            {
                writer.WritePropertyName("webApplicationFirewallPolicyLink"u8);
                JsonSerializer.Serialize(writer, WebApplicationFirewallPolicyLink);
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceState))
            {
                writer.WritePropertyName("resourceState"u8);
                writer.WriteStringValue(ResourceState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(CustomHttpsProvisioningState))
            {
                if (CustomHttpsProvisioningState != null)
                {
                    writer.WritePropertyName("customHttpsProvisioningState"u8);
                    writer.WriteStringValue(CustomHttpsProvisioningState.Value.ToString());
                }
                else
                {
                    writer.WriteNull("customHttpsProvisioningState");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(CustomHttpsProvisioningSubstate))
            {
                if (CustomHttpsProvisioningSubstate != null)
                {
                    writer.WritePropertyName("customHttpsProvisioningSubstate"u8);
                    writer.WriteStringValue(CustomHttpsProvisioningSubstate.Value.ToString());
                }
                else
                {
                    writer.WriteNull("customHttpsProvisioningSubstate");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(CustomHttpsConfiguration))
            {
                if (CustomHttpsConfiguration != null)
                {
                    writer.WritePropertyName("customHttpsConfiguration"u8);
                    writer.WriteObjectValue(CustomHttpsConfiguration, options);
                }
                else
                {
                    writer.WriteNull("customHttpsConfiguration");
                }
            }
            writer.WriteEndObject();
        }

        FrontendEndpointData IJsonModel<FrontendEndpointData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FrontendEndpointData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FrontendEndpointData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFrontendEndpointData(document.RootElement, options);
        }

        internal static FrontendEndpointData DeserializeFrontendEndpointData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType? type = default;
            string hostName = default;
            SessionAffinityEnabledState? sessionAffinityEnabledState = default;
            int? sessionAffinityTtlSeconds = default;
            WritableSubResource webApplicationFirewallPolicyLink = default;
            FrontDoorResourceState? resourceState = default;
            FrontendEndpointCustomHttpsProvisioningState? customHttpsProvisioningState = default;
            FrontendEndpointCustomHttpsProvisioningSubstate? customHttpsProvisioningSubstate = default;
            CustomHttpsConfiguration customHttpsConfiguration = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("hostName"u8))
                        {
                            hostName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sessionAffinityEnabledState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sessionAffinityEnabledState = new SessionAffinityEnabledState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("sessionAffinityTtlSeconds"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sessionAffinityTtlSeconds = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("webApplicationFirewallPolicyLink"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            webApplicationFirewallPolicyLink = JsonSerializer.Deserialize<WritableSubResource>(property0.Value.GetRawText());
                            continue;
                        }
                        if (property0.NameEquals("resourceState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            resourceState = new FrontDoorResourceState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("customHttpsProvisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                customHttpsProvisioningState = null;
                                continue;
                            }
                            customHttpsProvisioningState = new FrontendEndpointCustomHttpsProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("customHttpsProvisioningSubstate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                customHttpsProvisioningSubstate = null;
                                continue;
                            }
                            customHttpsProvisioningSubstate = new FrontendEndpointCustomHttpsProvisioningSubstate(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("customHttpsConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                customHttpsConfiguration = null;
                                continue;
                            }
                            customHttpsConfiguration = CustomHttpsConfiguration.DeserializeCustomHttpsConfiguration(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FrontendEndpointData(
                id,
                name,
                type,
                serializedAdditionalRawData,
                hostName,
                sessionAffinityEnabledState,
                sessionAffinityTtlSeconds,
                webApplicationFirewallPolicyLink,
                resourceState,
                customHttpsProvisioningState,
                customHttpsProvisioningSubstate,
                customHttpsConfiguration);
        }

        BinaryData IPersistableModel<FrontendEndpointData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FrontendEndpointData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FrontendEndpointData)} does not support writing '{options.Format}' format.");
            }
        }

        FrontendEndpointData IPersistableModel<FrontendEndpointData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FrontendEndpointData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFrontendEndpointData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FrontendEndpointData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FrontendEndpointData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
