// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.FrontDoor.Models;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.FrontDoor
{
    /// <summary>
    /// A class representing the FrontDoorWebApplicationFirewallPolicy data model.
    /// Defines web application firewall policy.
    /// </summary>
    public partial class FrontDoorWebApplicationFirewallPolicyData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FrontDoorWebApplicationFirewallPolicyData"/>. </summary>
        /// <param name="location"> The location. </param>
        public FrontDoorWebApplicationFirewallPolicyData(AzureLocation location) : base(location)
        {
            FrontendEndpointLinks = new ChangeTrackingList<SubResource>();
            RoutingRuleLinks = new ChangeTrackingList<SubResource>();
            SecurityPolicyLinks = new ChangeTrackingList<SubResource>();
        }

        /// <summary> Initializes a new instance of <see cref="FrontDoorWebApplicationFirewallPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> Gets a unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="sku"> The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if not specified. </param>
        /// <param name="policySettings"> Describes settings for the policy. </param>
        /// <param name="customRuleList"> Describes custom rules inside the policy. </param>
        /// <param name="managedRules"> Describes managed rules inside the policy. </param>
        /// <param name="frontendEndpointLinks"> Describes Frontend Endpoints associated with this Web Application Firewall policy. </param>
        /// <param name="routingRuleLinks"> Describes Routing Rules associated with this Web Application Firewall policy. </param>
        /// <param name="securityPolicyLinks"> Describes Security Policy associated with this Web Application Firewall policy. </param>
        /// <param name="provisioningState"> Provisioning state of the policy. </param>
        /// <param name="resourceState"> Resource status of the policy. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FrontDoorWebApplicationFirewallPolicyData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ETag? etag, FrontDoorSku sku, FrontDoorWebApplicationFirewallPolicySettings policySettings, CustomRuleList customRuleList, ManagedRuleSetList managedRules, IReadOnlyList<SubResource> frontendEndpointLinks, IReadOnlyList<SubResource> routingRuleLinks, IReadOnlyList<SubResource> securityPolicyLinks, string provisioningState, FrontDoorWebApplicationFirewallPolicyResourceState? resourceState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ETag = etag;
            Sku = sku;
            PolicySettings = policySettings;
            CustomRuleList = customRuleList;
            ManagedRules = managedRules;
            FrontendEndpointLinks = frontendEndpointLinks;
            RoutingRuleLinks = routingRuleLinks;
            SecurityPolicyLinks = securityPolicyLinks;
            ProvisioningState = provisioningState;
            ResourceState = resourceState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FrontDoorWebApplicationFirewallPolicyData"/> for deserialization. </summary>
        internal FrontDoorWebApplicationFirewallPolicyData()
        {
        }

        /// <summary> Gets a unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; set; }
        /// <summary> The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if not specified. </summary>
        internal FrontDoorSku Sku { get; set; }
        /// <summary> Name of the pricing tier. </summary>
        public FrontDoorSkuName? SkuName
        {
            get => Sku is null ? default : Sku.Name;
            set
            {
                if (Sku is null)
                    Sku = new FrontDoorSku();
                Sku.Name = value;
            }
        }

        /// <summary> Describes settings for the policy. </summary>
        public FrontDoorWebApplicationFirewallPolicySettings PolicySettings { get; set; }
        /// <summary> Describes custom rules inside the policy. </summary>
        internal CustomRuleList CustomRuleList { get; set; }
        /// <summary> List of rules. </summary>
        public IList<WebApplicationCustomRule> Rules
        {
            get
            {
                if (CustomRuleList is null)
                    CustomRuleList = new CustomRuleList();
                return CustomRuleList.Rules;
            }
        }

        /// <summary> Describes managed rules inside the policy. </summary>
        internal ManagedRuleSetList ManagedRules { get; set; }
        /// <summary> List of rule sets. </summary>
        public IList<ManagedRuleSet> ManagedRuleSets
        {
            get
            {
                if (ManagedRules is null)
                    ManagedRules = new ManagedRuleSetList();
                return ManagedRules.ManagedRuleSets;
            }
        }

        /// <summary> Describes Frontend Endpoints associated with this Web Application Firewall policy. </summary>
        public IReadOnlyList<SubResource> FrontendEndpointLinks { get; }
        /// <summary> Describes Routing Rules associated with this Web Application Firewall policy. </summary>
        public IReadOnlyList<SubResource> RoutingRuleLinks { get; }
        /// <summary> Describes Security Policy associated with this Web Application Firewall policy. </summary>
        public IReadOnlyList<SubResource> SecurityPolicyLinks { get; }
        /// <summary> Provisioning state of the policy. </summary>
        public string ProvisioningState { get; }
        /// <summary> Resource status of the policy. </summary>
        public FrontDoorWebApplicationFirewallPolicyResourceState? ResourceState { get; }
    }
}
