// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.FrontDoor.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.FrontDoor
{
    /// <summary>
    /// A class representing the FrontDoor data model.
    /// Front Door represents a collection of backend endpoints to route traffic to along with rules that specify how traffic is sent there.
    /// </summary>
    public partial class FrontDoorData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FrontDoorData"/>. </summary>
        /// <param name="location"> The location. </param>
        public FrontDoorData(AzureLocation location) : base(location)
        {
            RoutingRules = new ChangeTrackingList<RoutingRuleData>();
            LoadBalancingSettings = new ChangeTrackingList<FrontDoorLoadBalancingSettingsData>();
            HealthProbeSettings = new ChangeTrackingList<FrontDoorHealthProbeSettingsData>();
            BackendPools = new ChangeTrackingList<FrontDoorBackendPool>();
            FrontendEndpoints = new ChangeTrackingList<FrontendEndpointData>();
            RulesEngines = new ChangeTrackingList<FrontDoorRulesEngineData>();
            ExtendedProperties = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="FrontDoorData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="friendlyName"> A friendly name for the frontDoor. </param>
        /// <param name="routingRules"> Routing rules associated with this Front Door. </param>
        /// <param name="loadBalancingSettings"> Load balancing settings associated with this Front Door instance. </param>
        /// <param name="healthProbeSettings"> Health probe settings associated with this Front Door instance. </param>
        /// <param name="backendPools"> Backend pools available to routing rules. </param>
        /// <param name="frontendEndpoints"> Frontend endpoints available to routing rules. </param>
        /// <param name="backendPoolsSettings"> Settings for all backendPools. </param>
        /// <param name="enabledState"> Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'. </param>
        /// <param name="resourceState"> Resource status of the Front Door. </param>
        /// <param name="provisioningState"> Provisioning state of the Front Door. </param>
        /// <param name="cname"> The host that each frontendEndpoint must CNAME to. </param>
        /// <param name="frontdoorId"> The Id of the frontdoor. </param>
        /// <param name="rulesEngines"> Rules Engine Configurations available to routing rules. </param>
        /// <param name="extendedProperties"> Key-Value pair representing additional properties for frontdoor. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FrontDoorData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, string friendlyName, IList<RoutingRuleData> routingRules, IList<FrontDoorLoadBalancingSettingsData> loadBalancingSettings, IList<FrontDoorHealthProbeSettingsData> healthProbeSettings, IList<FrontDoorBackendPool> backendPools, IList<FrontendEndpointData> frontendEndpoints, BackendPoolsSettings backendPoolsSettings, FrontDoorEnabledState? enabledState, FrontDoorResourceState? resourceState, string provisioningState, string cname, string frontdoorId, IReadOnlyList<FrontDoorRulesEngineData> rulesEngines, IReadOnlyDictionary<string, string> extendedProperties, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            FriendlyName = friendlyName;
            RoutingRules = routingRules;
            LoadBalancingSettings = loadBalancingSettings;
            HealthProbeSettings = healthProbeSettings;
            BackendPools = backendPools;
            FrontendEndpoints = frontendEndpoints;
            BackendPoolsSettings = backendPoolsSettings;
            EnabledState = enabledState;
            ResourceState = resourceState;
            ProvisioningState = provisioningState;
            Cname = cname;
            FrontdoorId = frontdoorId;
            RulesEngines = rulesEngines;
            ExtendedProperties = extendedProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FrontDoorData"/> for deserialization. </summary>
        internal FrontDoorData()
        {
        }

        /// <summary> A friendly name for the frontDoor. </summary>
        public string FriendlyName { get; set; }
        /// <summary> Routing rules associated with this Front Door. </summary>
        public IList<RoutingRuleData> RoutingRules { get; }
        /// <summary> Load balancing settings associated with this Front Door instance. </summary>
        public IList<FrontDoorLoadBalancingSettingsData> LoadBalancingSettings { get; }
        /// <summary> Health probe settings associated with this Front Door instance. </summary>
        public IList<FrontDoorHealthProbeSettingsData> HealthProbeSettings { get; }
        /// <summary> Backend pools available to routing rules. </summary>
        public IList<FrontDoorBackendPool> BackendPools { get; }
        /// <summary> Frontend endpoints available to routing rules. </summary>
        public IList<FrontendEndpointData> FrontendEndpoints { get; }
        /// <summary> Settings for all backendPools. </summary>
        public BackendPoolsSettings BackendPoolsSettings { get; set; }
        /// <summary> Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'. </summary>
        public FrontDoorEnabledState? EnabledState { get; set; }
        /// <summary> Resource status of the Front Door. </summary>
        public FrontDoorResourceState? ResourceState { get; }
        /// <summary> Provisioning state of the Front Door. </summary>
        public string ProvisioningState { get; }
        /// <summary> The host that each frontendEndpoint must CNAME to. </summary>
        public string Cname { get; }
        /// <summary> The Id of the frontdoor. </summary>
        public string FrontdoorId { get; }
        /// <summary> Rules Engine Configurations available to routing rules. </summary>
        public IReadOnlyList<FrontDoorRulesEngineData> RulesEngines { get; }
        /// <summary> Key-Value pair representing additional properties for frontdoor. </summary>
        public IReadOnlyDictionary<string, string> ExtendedProperties { get; }
    }
}
