// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.FrontDoor.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmFrontDoorModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="FrontDoor.FrontDoorWebApplicationFirewallPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> Gets a unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="skuName"> The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if not specified. </param>
        /// <param name="policySettings"> Describes settings for the policy. </param>
        /// <param name="rules"> Describes custom rules inside the policy. </param>
        /// <param name="managedRuleSets"> Describes managed rules inside the policy. </param>
        /// <param name="frontendEndpointLinks"> Describes Frontend Endpoints associated with this Web Application Firewall policy. </param>
        /// <param name="routingRuleLinks"> Describes Routing Rules associated with this Web Application Firewall policy. </param>
        /// <param name="securityPolicyLinks"> Describes Security Policy associated with this Web Application Firewall policy. </param>
        /// <param name="provisioningState"> Provisioning state of the policy. </param>
        /// <param name="resourceState"> Resource status of the policy. </param>
        /// <returns> A new <see cref="FrontDoor.FrontDoorWebApplicationFirewallPolicyData"/> instance for mocking. </returns>
        public static FrontDoorWebApplicationFirewallPolicyData FrontDoorWebApplicationFirewallPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ETag? etag = null, FrontDoorSkuName? skuName = null, FrontDoorWebApplicationFirewallPolicySettings policySettings = null, IEnumerable<WebApplicationCustomRule> rules = null, IEnumerable<ManagedRuleSet> managedRuleSets = null, IEnumerable<SubResource> frontendEndpointLinks = null, IEnumerable<SubResource> routingRuleLinks = null, IEnumerable<SubResource> securityPolicyLinks = null, string provisioningState = null, FrontDoorWebApplicationFirewallPolicyResourceState? resourceState = null)
        {
            tags ??= new Dictionary<string, string>();
            rules ??= new List<WebApplicationCustomRule>();
            managedRuleSets ??= new List<ManagedRuleSet>();
            frontendEndpointLinks ??= new List<SubResource>();
            routingRuleLinks ??= new List<SubResource>();
            securityPolicyLinks ??= new List<SubResource>();

            return new FrontDoorWebApplicationFirewallPolicyData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                etag,
                skuName != null ? new FrontDoorSku(skuName, serializedAdditionalRawData: null) : null,
                policySettings,
                rules != null ? new CustomRuleList(rules?.ToList(), serializedAdditionalRawData: null) : null,
                managedRuleSets != null ? new ManagedRuleSetList(managedRuleSets?.ToList(), serializedAdditionalRawData: null) : null,
                frontendEndpointLinks?.ToList(),
                routingRuleLinks?.ToList(),
                securityPolicyLinks?.ToList(),
                provisioningState,
                resourceState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedRuleSetDefinition"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> Provisioning state of the managed rule set. </param>
        /// <param name="ruleSetId"> Id of the managed rule set. </param>
        /// <param name="ruleSetType"> Type of the managed rule set. </param>
        /// <param name="ruleSetVersion"> Version of the managed rule set type. </param>
        /// <param name="ruleGroups"> Rule groups of the managed rule set. </param>
        /// <returns> A new <see cref="Models.ManagedRuleSetDefinition"/> instance for mocking. </returns>
        public static ManagedRuleSetDefinition ManagedRuleSetDefinition(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string provisioningState = null, string ruleSetId = null, string ruleSetType = null, string ruleSetVersion = null, IEnumerable<ManagedRuleGroupDefinition> ruleGroups = null)
        {
            tags ??= new Dictionary<string, string>();
            ruleGroups ??= new List<ManagedRuleGroupDefinition>();

            return new ManagedRuleSetDefinition(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                ruleSetId,
                ruleSetType,
                ruleSetVersion,
                ruleGroups?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedRuleGroupDefinition"/>. </summary>
        /// <param name="ruleGroupName"> Name of the managed rule group. </param>
        /// <param name="description"> Description of the managed rule group. </param>
        /// <param name="rules"> List of rules within the managed rule group. </param>
        /// <returns> A new <see cref="Models.ManagedRuleGroupDefinition"/> instance for mocking. </returns>
        public static ManagedRuleGroupDefinition ManagedRuleGroupDefinition(string ruleGroupName = null, string description = null, IEnumerable<ManagedRuleDefinition> rules = null)
        {
            rules ??= new List<ManagedRuleDefinition>();

            return new ManagedRuleGroupDefinition(ruleGroupName, description, rules?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedRuleDefinition"/>. </summary>
        /// <param name="ruleId"> Identifier for the managed rule. </param>
        /// <param name="defaultState"> Describes the default state for the managed rule. </param>
        /// <param name="defaultAction"> Describes the default action to be applied when the managed rule matches. </param>
        /// <param name="description"> Describes the functionality of the managed rule. </param>
        /// <returns> A new <see cref="Models.ManagedRuleDefinition"/> instance for mocking. </returns>
        public static ManagedRuleDefinition ManagedRuleDefinition(string ruleId = null, ManagedRuleEnabledState? defaultState = null, RuleMatchActionType? defaultAction = null, string description = null)
        {
            return new ManagedRuleDefinition(ruleId, defaultState, defaultAction, description, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorNameAvailabilityResult"/>. </summary>
        /// <param name="nameAvailability"> Indicates whether the name is available. </param>
        /// <param name="reason"> The reason why the name is not available. </param>
        /// <param name="message"> The detailed error message describing why the name is not available. </param>
        /// <returns> A new <see cref="Models.FrontDoorNameAvailabilityResult"/> instance for mocking. </returns>
        public static FrontDoorNameAvailabilityResult FrontDoorNameAvailabilityResult(FrontDoorNameAvailabilityState? nameAvailability = null, string reason = null, string message = null)
        {
            return new FrontDoorNameAvailabilityResult(nameAvailability, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="FrontDoor.FrontDoorData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="friendlyName"> A friendly name for the frontDoor. </param>
        /// <param name="routingRules"> Routing rules associated with this Front Door. </param>
        /// <param name="loadBalancingSettings"> Load balancing settings associated with this Front Door instance. </param>
        /// <param name="healthProbeSettings"> Health probe settings associated with this Front Door instance. </param>
        /// <param name="backendPools"> Backend pools available to routing rules. </param>
        /// <param name="frontendEndpoints"> Frontend endpoints available to routing rules. </param>
        /// <param name="backendPoolsSettings"> Settings for all backendPools. </param>
        /// <param name="enabledState"> Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'. </param>
        /// <param name="resourceState"> Resource status of the Front Door. </param>
        /// <param name="provisioningState"> Provisioning state of the Front Door. </param>
        /// <param name="cname"> The host that each frontendEndpoint must CNAME to. </param>
        /// <param name="frontdoorId"> The Id of the frontdoor. </param>
        /// <param name="rulesEngines"> Rules Engine Configurations available to routing rules. </param>
        /// <param name="extendedProperties"> Key-Value pair representing additional properties for frontdoor. </param>
        /// <returns> A new <see cref="FrontDoor.FrontDoorData"/> instance for mocking. </returns>
        public static FrontDoorData FrontDoorData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string friendlyName = null, IEnumerable<RoutingRuleData> routingRules = null, IEnumerable<FrontDoorLoadBalancingSettingsData> loadBalancingSettings = null, IEnumerable<FrontDoorHealthProbeSettingsData> healthProbeSettings = null, IEnumerable<FrontDoorBackendPool> backendPools = null, IEnumerable<FrontendEndpointData> frontendEndpoints = null, BackendPoolsSettings backendPoolsSettings = null, FrontDoorEnabledState? enabledState = null, FrontDoorResourceState? resourceState = null, string provisioningState = null, string cname = null, string frontdoorId = null, IEnumerable<FrontDoorRulesEngineData> rulesEngines = null, IReadOnlyDictionary<string, string> extendedProperties = null)
        {
            tags ??= new Dictionary<string, string>();
            routingRules ??= new List<RoutingRuleData>();
            loadBalancingSettings ??= new List<FrontDoorLoadBalancingSettingsData>();
            healthProbeSettings ??= new List<FrontDoorHealthProbeSettingsData>();
            backendPools ??= new List<FrontDoorBackendPool>();
            frontendEndpoints ??= new List<FrontendEndpointData>();
            rulesEngines ??= new List<FrontDoorRulesEngineData>();
            extendedProperties ??= new Dictionary<string, string>();

            return new FrontDoorData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                friendlyName,
                routingRules?.ToList(),
                loadBalancingSettings?.ToList(),
                healthProbeSettings?.ToList(),
                backendPools?.ToList(),
                frontendEndpoints?.ToList(),
                backendPoolsSettings,
                enabledState,
                resourceState,
                provisioningState,
                cname,
                frontdoorId,
                rulesEngines?.ToList(),
                extendedProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="FrontDoor.FrontDoorRulesEngineData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="rules"> A list of rules that define a particular Rules Engine Configuration. </param>
        /// <param name="resourceState"> Resource status. </param>
        /// <returns> A new <see cref="FrontDoor.FrontDoorRulesEngineData"/> instance for mocking. </returns>
        public static FrontDoorRulesEngineData FrontDoorRulesEngineData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IEnumerable<RulesEngineRule> rules = null, FrontDoorResourceState? resourceState = null)
        {
            rules ??= new List<RulesEngineRule>();

            return new FrontDoorRulesEngineData(
                id,
                name,
                resourceType,
                systemData,
                rules?.ToList(),
                resourceState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RoutingRuleData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="frontendEndpoints"> Frontend endpoints associated with this rule. </param>
        /// <param name="acceptedProtocols"> Protocol schemes to match for this rule. </param>
        /// <param name="patternsToMatch"> The route patterns of the rule. </param>
        /// <param name="enabledState"> Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. </param>
        /// <param name="routeConfiguration">
        /// A reference to the routing configuration.
        /// Please note <see cref="RouteConfiguration"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ForwardingConfiguration"/> and <see cref="RedirectConfiguration"/>.
        /// </param>
        /// <param name="rulesEngineId"> A reference to a specific Rules Engine Configuration to apply to this route. </param>
        /// <param name="webApplicationFirewallPolicyLinkId"> Defines the Web Application Firewall policy for each routing rule (if applicable). </param>
        /// <param name="resourceState"> Resource status. </param>
        /// <returns> A new <see cref="Models.RoutingRuleData"/> instance for mocking. </returns>
        public static RoutingRuleData RoutingRuleData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, IEnumerable<WritableSubResource> frontendEndpoints = null, IEnumerable<FrontDoorProtocol> acceptedProtocols = null, IEnumerable<string> patternsToMatch = null, RoutingRuleEnabledState? enabledState = null, RouteConfiguration routeConfiguration = null, ResourceIdentifier rulesEngineId = null, ResourceIdentifier webApplicationFirewallPolicyLinkId = null, FrontDoorResourceState? resourceState = null)
        {
            frontendEndpoints ??= new List<WritableSubResource>();
            acceptedProtocols ??= new List<FrontDoorProtocol>();
            patternsToMatch ??= new List<string>();

            return new RoutingRuleData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                frontendEndpoints?.ToList(),
                acceptedProtocols?.ToList(),
                patternsToMatch?.ToList(),
                enabledState,
                routeConfiguration,
                rulesEngineId != null ? ResourceManagerModelFactory.WritableSubResource(rulesEngineId) : null,
                webApplicationFirewallPolicyLinkId != null ? ResourceManagerModelFactory.WritableSubResource(webApplicationFirewallPolicyLinkId) : null,
                resourceState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorResourceData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <returns> A new <see cref="Models.FrontDoorResourceData"/> instance for mocking. </returns>
        public static FrontDoorResourceData FrontDoorResourceData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null)
        {
            return new FrontDoorResourceData(id, name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorLoadBalancingSettingsData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="sampleSize"> The number of samples to consider for load balancing decisions. </param>
        /// <param name="successfulSamplesRequired"> The number of samples within the sample period that must succeed. </param>
        /// <param name="additionalLatencyMilliseconds"> The additional latency in milliseconds for probes to fall into the lowest latency bucket. </param>
        /// <param name="resourceState"> Resource status. </param>
        /// <returns> A new <see cref="Models.FrontDoorLoadBalancingSettingsData"/> instance for mocking. </returns>
        public static FrontDoorLoadBalancingSettingsData FrontDoorLoadBalancingSettingsData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, int? sampleSize = null, int? successfulSamplesRequired = null, int? additionalLatencyMilliseconds = null, FrontDoorResourceState? resourceState = null)
        {
            return new FrontDoorLoadBalancingSettingsData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                sampleSize,
                successfulSamplesRequired,
                additionalLatencyMilliseconds,
                resourceState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorHealthProbeSettingsData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="path"> The path to use for the health probe. Default is /. </param>
        /// <param name="protocol"> Protocol scheme to use for this probe. </param>
        /// <param name="intervalInSeconds"> The number of seconds between health probes. </param>
        /// <param name="healthProbeMethod"> Configures which HTTP method to use to probe the backends defined under backendPools. </param>
        /// <param name="enabledState"> Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool. </param>
        /// <param name="resourceState"> Resource status. </param>
        /// <returns> A new <see cref="Models.FrontDoorHealthProbeSettingsData"/> instance for mocking. </returns>
        public static FrontDoorHealthProbeSettingsData FrontDoorHealthProbeSettingsData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, string path = null, FrontDoorProtocol? protocol = null, int? intervalInSeconds = null, FrontDoorHealthProbeMethod? healthProbeMethod = null, HealthProbeEnabled? enabledState = null, FrontDoorResourceState? resourceState = null)
        {
            return new FrontDoorHealthProbeSettingsData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                path,
                protocol,
                intervalInSeconds,
                healthProbeMethod,
                enabledState,
                resourceState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorBackendPool"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="backends"> The set of backends for this pool. </param>
        /// <param name="loadBalancingSettingsId"> Load balancing settings for a backend pool. </param>
        /// <param name="healthProbeSettingsId"> L7 health probe settings for a backend pool. </param>
        /// <param name="resourceState"> Resource status. </param>
        /// <returns> A new <see cref="Models.FrontDoorBackendPool"/> instance for mocking. </returns>
        public static FrontDoorBackendPool FrontDoorBackendPool(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, IEnumerable<FrontDoorBackend> backends = null, ResourceIdentifier loadBalancingSettingsId = null, ResourceIdentifier healthProbeSettingsId = null, FrontDoorResourceState? resourceState = null)
        {
            backends ??= new List<FrontDoorBackend>();

            return new FrontDoorBackendPool(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                backends?.ToList(),
                loadBalancingSettingsId != null ? ResourceManagerModelFactory.WritableSubResource(loadBalancingSettingsId) : null,
                healthProbeSettingsId != null ? ResourceManagerModelFactory.WritableSubResource(healthProbeSettingsId) : null,
                resourceState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorBackend"/>. </summary>
        /// <param name="address"> Location of the backend (IP address or FQDN). </param>
        /// <param name="privateLinkAlias"> The Alias of the Private Link resource. Populating this optional field indicates that this backend is 'Private'. </param>
        /// <param name="privateLinkResourceId"> The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'. </param>
        /// <param name="privateLinkLocation"> The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated. </param>
        /// <param name="privateEndpointStatus"> The Approval status for the connection to the Private Link. </param>
        /// <param name="privateLinkApprovalMessage"> A custom message to be included in the approval request to connect to the Private Link. </param>
        /// <param name="httpPort"> The HTTP TCP port number. Must be between 1 and 65535. </param>
        /// <param name="httpsPort"> The HTTPS TCP port number. Must be between 1 and 65535. </param>
        /// <param name="enabledState"> Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'. </param>
        /// <param name="priority"> Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy. </param>
        /// <param name="weight"> Weight of this endpoint for load balancing purposes. </param>
        /// <param name="backendHostHeader"> The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host. </param>
        /// <returns> A new <see cref="Models.FrontDoorBackend"/> instance for mocking. </returns>
        public static FrontDoorBackend FrontDoorBackend(string address = null, string privateLinkAlias = null, ResourceIdentifier privateLinkResourceId = null, AzureLocation? privateLinkLocation = null, BackendPrivateEndpointStatus? privateEndpointStatus = null, string privateLinkApprovalMessage = null, int? httpPort = null, int? httpsPort = null, BackendEnabledState? enabledState = null, int? priority = null, int? weight = null, string backendHostHeader = null)
        {
            return new FrontDoorBackend(
                address,
                privateLinkAlias,
                privateLinkResourceId,
                privateLinkLocation,
                privateEndpointStatus,
                privateLinkApprovalMessage,
                httpPort,
                httpsPort,
                enabledState,
                priority,
                weight,
                backendHostHeader,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="FrontDoor.FrontendEndpointData"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="name"> Resource name. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="hostName"> The host name of the frontendEndpoint. Must be a domain name. </param>
        /// <param name="sessionAffinityEnabledState"> Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'. </param>
        /// <param name="sessionAffinityTtlInSeconds"> UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable. </param>
        /// <param name="webApplicationFirewallPolicyLinkId"> Defines the Web Application Firewall policy for each host (if applicable). </param>
        /// <param name="resourceState"> Resource status. </param>
        /// <param name="customHttpsProvisioningState"> Provisioning status of Custom Https of the frontendEndpoint. </param>
        /// <param name="customHttpsProvisioningSubstate"> Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. </param>
        /// <param name="customHttpsConfiguration"> The configuration specifying how to enable HTTPS. </param>
        /// <returns> A new <see cref="FrontDoor.FrontendEndpointData"/> instance for mocking. </returns>
        public static FrontendEndpointData FrontendEndpointData(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, string hostName = null, SessionAffinityEnabledState? sessionAffinityEnabledState = null, int? sessionAffinityTtlInSeconds = null, ResourceIdentifier webApplicationFirewallPolicyLinkId = null, FrontDoorResourceState? resourceState = null, FrontendEndpointCustomHttpsProvisioningState? customHttpsProvisioningState = null, FrontendEndpointCustomHttpsProvisioningSubstate? customHttpsProvisioningSubstate = null, CustomHttpsConfiguration customHttpsConfiguration = null)
        {
            return new FrontendEndpointData(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                hostName,
                sessionAffinityEnabledState,
                sessionAffinityTtlInSeconds,
                webApplicationFirewallPolicyLinkId != null ? ResourceManagerModelFactory.WritableSubResource(webApplicationFirewallPolicyLinkId) : null,
                resourceState,
                customHttpsProvisioningState,
                customHttpsProvisioningSubstate,
                customHttpsConfiguration);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorValidateCustomDomainResult"/>. </summary>
        /// <param name="isCustomDomainValidated"> Indicates whether the custom domain is valid or not. </param>
        /// <param name="reason"> The reason why the custom domain is not valid. </param>
        /// <param name="message"> Error message describing why the custom domain is not valid. </param>
        /// <returns> A new <see cref="Models.FrontDoorValidateCustomDomainResult"/> instance for mocking. </returns>
        public static FrontDoorValidateCustomDomainResult FrontDoorValidateCustomDomainResult(bool? isCustomDomainValidated = null, string reason = null, string message = null)
        {
            return new FrontDoorValidateCustomDomainResult(isCustomDomainValidated, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="FrontDoor.FrontDoorNetworkExperimentProfileData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> Gets a unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="resourceState"> Resource status. </param>
        /// <param name="enabledState"> The state of the Experiment. </param>
        /// <returns> A new <see cref="FrontDoor.FrontDoorNetworkExperimentProfileData"/> instance for mocking. </returns>
        public static FrontDoorNetworkExperimentProfileData FrontDoorNetworkExperimentProfileData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ETag? etag = null, NetworkExperimentResourceState? resourceState = null, FrontDoorExperimentState? enabledState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new FrontDoorNetworkExperimentProfileData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                etag,
                resourceState,
                enabledState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PreconfiguredEndpoint"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="description"> The description of the endpoint. </param>
        /// <param name="endpoint"> The endpoint that is preconfigured. </param>
        /// <param name="endpointType"> The type of endpoint. </param>
        /// <param name="backend"> The preconfigured endpoint backend. </param>
        /// <returns> A new <see cref="Models.PreconfiguredEndpoint"/> instance for mocking. </returns>
        public static PreconfiguredEndpoint PreconfiguredEndpoint(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string description = null, string endpoint = null, FrontDoorEndpointType? endpointType = null, string backend = null)
        {
            tags ??= new Dictionary<string, string>();

            return new PreconfiguredEndpoint(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                description,
                endpoint,
                endpointType,
                backend,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="FrontDoor.FrontDoorExperimentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="description"> The description of the details or intents of the Experiment. </param>
        /// <param name="experimentEndpointA"> The endpoint A of an experiment. </param>
        /// <param name="experimentEndpointB"> The endpoint B of an experiment. </param>
        /// <param name="enabledState"> The state of the Experiment. </param>
        /// <param name="resourceState"> Resource status. </param>
        /// <param name="status"> The description of Experiment status from the server side. </param>
        /// <param name="scriptFileUri"> The uri to the Script used in the Experiment. </param>
        /// <returns> A new <see cref="FrontDoor.FrontDoorExperimentData"/> instance for mocking. </returns>
        public static FrontDoorExperimentData FrontDoorExperimentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string description = null, FrontDoorExperimentEndpointProperties experimentEndpointA = null, FrontDoorExperimentEndpointProperties experimentEndpointB = null, FrontDoorExperimentState? enabledState = null, NetworkExperimentResourceState? resourceState = null, string status = null, Uri scriptFileUri = null)
        {
            tags ??= new Dictionary<string, string>();

            return new FrontDoorExperimentData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                description,
                experimentEndpointA,
                experimentEndpointB,
                enabledState,
                resourceState,
                status,
                scriptFileUri,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LatencyScorecard"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="latencyScorecardId"> The unique identifier of the Latency Scorecard. </param>
        /// <param name="latencyScorecardName"> The name of the Latency Scorecard. </param>
        /// <param name="description"> The description of the Latency Scorecard. </param>
        /// <param name="scorecardEndpointA"> The A endpoint in the scorecard. </param>
        /// <param name="scorecardEndpointB"> The B endpoint in the scorecard. </param>
        /// <param name="startOn"> The start time of the Latency Scorecard in UTC. </param>
        /// <param name="endOn"> The end time of the Latency Scorecard in UTC. </param>
        /// <param name="country"> The country associated with the Latency Scorecard. Values are country ISO codes as specified here- https://www.iso.org/iso-3166-country-codes.html. </param>
        /// <param name="latencyMetrics"> The latency metrics of the Latency Scorecard. </param>
        /// <returns> A new <see cref="Models.LatencyScorecard"/> instance for mocking. </returns>
        public static LatencyScorecard LatencyScorecard(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string latencyScorecardId = null, string latencyScorecardName = null, string description = null, Uri scorecardEndpointA = null, Uri scorecardEndpointB = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, string country = null, IEnumerable<LatencyMetric> latencyMetrics = null)
        {
            tags ??= new Dictionary<string, string>();
            latencyMetrics ??= new List<LatencyMetric>();

            return new LatencyScorecard(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                latencyScorecardId,
                latencyScorecardName,
                description,
                scorecardEndpointA,
                scorecardEndpointB,
                startOn,
                endOn,
                country,
                latencyMetrics?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LatencyMetric"/>. </summary>
        /// <param name="name"> The name of the Latency Metric. </param>
        /// <param name="endOn"> The end time of the Latency Scorecard in UTC. </param>
        /// <param name="aValue"> The metric value of the A endpoint. </param>
        /// <param name="bValue"> The metric value of the B endpoint. </param>
        /// <param name="delta"> The difference in value between endpoint A and B. </param>
        /// <param name="deltaPercent"> The percent difference between endpoint A and B. </param>
        /// <param name="acLower95CI"> The lower end of the 95% confidence interval for endpoint A. </param>
        /// <param name="ahUpper95CI"> The upper end of the 95% confidence interval for endpoint A. </param>
        /// <param name="bcLower95CI"> The lower end of the 95% confidence interval for endpoint B. </param>
        /// <param name="bUpper95CI"> The upper end of the 95% confidence interval for endpoint B. </param>
        /// <returns> A new <see cref="Models.LatencyMetric"/> instance for mocking. </returns>
        public static LatencyMetric LatencyMetric(string name = null, DateTimeOffset? endOn = null, float? aValue = null, float? bValue = null, float? delta = null, float? deltaPercent = null, float? acLower95CI = null, float? ahUpper95CI = null, float? bcLower95CI = null, float? bUpper95CI = null)
        {
            return new LatencyMetric(
                name,
                endOn,
                aValue,
                bValue,
                delta,
                deltaPercent,
                acLower95CI,
                ahUpper95CI,
                bcLower95CI,
                bUpper95CI,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FrontDoorTimeSeriesInfo"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="endpoint"> The endpoint associated with the Timeseries data point. </param>
        /// <param name="startOn"> The start DateTime of the Timeseries in UTC. </param>
        /// <param name="endOn"> The end DateTime of the Timeseries in UTC. </param>
        /// <param name="aggregationInterval"> The aggregation interval of the Timeseries. </param>
        /// <param name="timeSeriesType"> The type of Timeseries. </param>
        /// <param name="country"> The country associated with the Timeseries. Values are country ISO codes as specified here- https://www.iso.org/iso-3166-country-codes.html. </param>
        /// <param name="timeSeriesData"> The set of data points for the timeseries. </param>
        /// <returns> A new <see cref="Models.FrontDoorTimeSeriesInfo"/> instance for mocking. </returns>
        public static FrontDoorTimeSeriesInfo FrontDoorTimeSeriesInfo(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, Uri endpoint = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, FrontDoorTimeSeriesInfoAggregationInterval? aggregationInterval = null, FrontDoorTimeSeriesType? timeSeriesType = null, string country = null, IEnumerable<FrontDoorTimeSeriesDataPoint> timeSeriesData = null)
        {
            tags ??= new Dictionary<string, string>();
            timeSeriesData ??= new List<FrontDoorTimeSeriesDataPoint>();

            return new FrontDoorTimeSeriesInfo(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                endpoint,
                startOn,
                endOn,
                aggregationInterval,
                timeSeriesType,
                country,
                timeSeriesData?.ToList(),
                serializedAdditionalRawData: null);
        }
    }
}
