// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.FrontDoor.Samples
{
    public partial class Sample_FrontendEndpointCollection
    {
        // List Frontend endpoints in a Front Door
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListFrontendEndpointsInAFrontDoor()
        {
            // Generated from example definition: specification/frontdoor/resource-manager/Microsoft.Network/stable/2021-06-01/examples/FrontdoorFrontendEndpointList.json
            // this example is just showing the usage of "FrontendEndpoints_ListByFrontDoor" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorResource created on azure
            // for more information of creating FrontDoorResource, please refer to the document of FrontDoorResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string frontDoorName = "frontDoor1";
            ResourceIdentifier frontDoorResourceId = FrontDoorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, frontDoorName);
            FrontDoorResource frontDoor = client.GetFrontDoorResource(frontDoorResourceId);

            // get the collection of this FrontendEndpointResource
            FrontendEndpointCollection collection = frontDoor.GetFrontendEndpoints();

            // invoke the operation and iterate over the result
            await foreach (FrontendEndpointResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                FrontendEndpointData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get Frontend Endpoint
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetFrontendEndpoint()
        {
            // Generated from example definition: specification/frontdoor/resource-manager/Microsoft.Network/stable/2021-06-01/examples/FrontdoorFrontendEndpointGet.json
            // this example is just showing the usage of "FrontendEndpoints_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorResource created on azure
            // for more information of creating FrontDoorResource, please refer to the document of FrontDoorResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string frontDoorName = "frontDoor1";
            ResourceIdentifier frontDoorResourceId = FrontDoorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, frontDoorName);
            FrontDoorResource frontDoor = client.GetFrontDoorResource(frontDoorResourceId);

            // get the collection of this FrontendEndpointResource
            FrontendEndpointCollection collection = frontDoor.GetFrontendEndpoints();

            // invoke the operation
            string frontendEndpointName = "frontendEndpoint1";
            FrontendEndpointResource result = await collection.GetAsync(frontendEndpointName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FrontendEndpointData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Frontend Endpoint
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetFrontendEndpoint()
        {
            // Generated from example definition: specification/frontdoor/resource-manager/Microsoft.Network/stable/2021-06-01/examples/FrontdoorFrontendEndpointGet.json
            // this example is just showing the usage of "FrontendEndpoints_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorResource created on azure
            // for more information of creating FrontDoorResource, please refer to the document of FrontDoorResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string frontDoorName = "frontDoor1";
            ResourceIdentifier frontDoorResourceId = FrontDoorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, frontDoorName);
            FrontDoorResource frontDoor = client.GetFrontDoorResource(frontDoorResourceId);

            // get the collection of this FrontendEndpointResource
            FrontendEndpointCollection collection = frontDoor.GetFrontendEndpoints();

            // invoke the operation
            string frontendEndpointName = "frontendEndpoint1";
            bool result = await collection.ExistsAsync(frontendEndpointName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Frontend Endpoint
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetFrontendEndpoint()
        {
            // Generated from example definition: specification/frontdoor/resource-manager/Microsoft.Network/stable/2021-06-01/examples/FrontdoorFrontendEndpointGet.json
            // this example is just showing the usage of "FrontendEndpoints_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorResource created on azure
            // for more information of creating FrontDoorResource, please refer to the document of FrontDoorResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string frontDoorName = "frontDoor1";
            ResourceIdentifier frontDoorResourceId = FrontDoorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, frontDoorName);
            FrontDoorResource frontDoor = client.GetFrontDoorResource(frontDoorResourceId);

            // get the collection of this FrontendEndpointResource
            FrontendEndpointCollection collection = frontDoor.GetFrontendEndpoints();

            // invoke the operation
            string frontendEndpointName = "frontendEndpoint1";
            NullableResponse<FrontendEndpointResource> response = await collection.GetIfExistsAsync(frontendEndpointName);
            FrontendEndpointResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                FrontendEndpointData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
