// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.FrontDoor.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.FrontDoor.Samples
{
    public partial class Sample_FrontDoorWebApplicationFirewallPolicyResource
    {
        // Get all Policies in a Resource Group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetFrontDoorWebApplicationFirewallPoliciesByFrontDoorWebApplicationFirewallPolicy_GetAllPoliciesInAResourceGroup()
        {
            // Generated from example definition: specification/frontdoor/resource-manager/Microsoft.Network/stable/2024-02-01/examples/WafListPoliciesUnderSubscription.json
            // this example is just showing the usage of "Policies_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "subid";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (FrontDoorWebApplicationFirewallPolicyResource item in subscriptionResource.GetFrontDoorWebApplicationFirewallPoliciesByFrontDoorWebApplicationFirewallPolicyAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                FrontDoorWebApplicationFirewallPolicyData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get Policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetPolicy()
        {
            // Generated from example definition: specification/frontdoor/resource-manager/Microsoft.Network/stable/2024-02-01/examples/WafPolicyGet.json
            // this example is just showing the usage of "Policies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorWebApplicationFirewallPolicyResource created on azure
            // for more information of creating FrontDoorWebApplicationFirewallPolicyResource, please refer to the document of FrontDoorWebApplicationFirewallPolicyResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string policyName = "Policy1";
            ResourceIdentifier frontDoorWebApplicationFirewallPolicyResourceId = FrontDoorWebApplicationFirewallPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, policyName);
            FrontDoorWebApplicationFirewallPolicyResource frontDoorWebApplicationFirewallPolicy = client.GetFrontDoorWebApplicationFirewallPolicyResource(frontDoorWebApplicationFirewallPolicyResourceId);

            // invoke the operation
            FrontDoorWebApplicationFirewallPolicyResource result = await frontDoorWebApplicationFirewallPolicy.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FrontDoorWebApplicationFirewallPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Patches specific policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PatchesSpecificPolicy()
        {
            // Generated from example definition: specification/frontdoor/resource-manager/Microsoft.Network/stable/2024-02-01/examples/WafPolicyPatch.json
            // this example is just showing the usage of "Policies_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorWebApplicationFirewallPolicyResource created on azure
            // for more information of creating FrontDoorWebApplicationFirewallPolicyResource, please refer to the document of FrontDoorWebApplicationFirewallPolicyResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string policyName = "Policy1";
            ResourceIdentifier frontDoorWebApplicationFirewallPolicyResourceId = FrontDoorWebApplicationFirewallPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, policyName);
            FrontDoorWebApplicationFirewallPolicyResource frontDoorWebApplicationFirewallPolicy = client.GetFrontDoorWebApplicationFirewallPolicyResource(frontDoorWebApplicationFirewallPolicyResourceId);

            // invoke the operation
            FrontDoorWebApplicationFirewallPolicyPatch patch = new FrontDoorWebApplicationFirewallPolicyPatch()
            {
                Tags =
{
["key1"] = "value1",
["key2"] = "value2",
},
            };
            ArmOperation<FrontDoorWebApplicationFirewallPolicyResource> lro = await frontDoorWebApplicationFirewallPolicy.UpdateAsync(WaitUntil.Completed, patch);
            FrontDoorWebApplicationFirewallPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FrontDoorWebApplicationFirewallPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete protection policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteProtectionPolicy()
        {
            // Generated from example definition: specification/frontdoor/resource-manager/Microsoft.Network/stable/2024-02-01/examples/WafPolicyDelete.json
            // this example is just showing the usage of "Policies_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorWebApplicationFirewallPolicyResource created on azure
            // for more information of creating FrontDoorWebApplicationFirewallPolicyResource, please refer to the document of FrontDoorWebApplicationFirewallPolicyResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string policyName = "Policy1";
            ResourceIdentifier frontDoorWebApplicationFirewallPolicyResourceId = FrontDoorWebApplicationFirewallPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, policyName);
            FrontDoorWebApplicationFirewallPolicyResource frontDoorWebApplicationFirewallPolicy = client.GetFrontDoorWebApplicationFirewallPolicyResource(frontDoorWebApplicationFirewallPolicyResourceId);

            // invoke the operation
            await frontDoorWebApplicationFirewallPolicy.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
