// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.FrontDoor.Models;

namespace Azure.ResourceManager.FrontDoor.Samples
{
    public partial class Sample_FrontDoorExperimentResource
    {
        // Gets an Experiment by ExperimentName
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsAnExperimentByExperimentName()
        {
            // Generated from example definition: specification/frontdoor/resource-manager/Microsoft.Network/stable/2019-11-01/examples/NetworkExperimentGetExperiment.json
            // this example is just showing the usage of "Experiments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorExperimentResource created on azure
            // for more information of creating FrontDoorExperimentResource, please refer to the document of FrontDoorExperimentResource
            string subscriptionId = "subid";
            string resourceGroupName = "MyResourceGroup";
            string profileName = "MyProfile";
            string experimentName = "MyExperiment";
            ResourceIdentifier frontDoorExperimentResourceId = FrontDoorExperimentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, profileName, experimentName);
            FrontDoorExperimentResource frontDoorExperiment = client.GetFrontDoorExperimentResource(frontDoorExperimentResourceId);

            // invoke the operation
            FrontDoorExperimentResource result = await frontDoorExperiment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FrontDoorExperimentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Updates an Experiment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesAnExperiment()
        {
            // Generated from example definition: specification/frontdoor/resource-manager/Microsoft.Network/stable/2019-11-01/examples/NetworkExperimentUpdateExperiment.json
            // this example is just showing the usage of "Experiments_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorExperimentResource created on azure
            // for more information of creating FrontDoorExperimentResource, please refer to the document of FrontDoorExperimentResource
            string subscriptionId = "subid";
            string resourceGroupName = "MyResourceGroup";
            string profileName = "MyProfile";
            string experimentName = "MyExperiment";
            ResourceIdentifier frontDoorExperimentResourceId = FrontDoorExperimentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, profileName, experimentName);
            FrontDoorExperimentResource frontDoorExperiment = client.GetFrontDoorExperimentResource(frontDoorExperimentResourceId);

            // invoke the operation
            FrontDoorExperimentPatch patch = new FrontDoorExperimentPatch()
            {
                Description = "string",
                EnabledState = FrontDoorExperimentState.Enabled,
            };
            ArmOperation<FrontDoorExperimentResource> lro = await frontDoorExperiment.UpdateAsync(WaitUntil.Completed, patch);
            FrontDoorExperimentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FrontDoorExperimentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Deletes an Experiment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeletesAnExperiment()
        {
            // Generated from example definition: specification/frontdoor/resource-manager/Microsoft.Network/stable/2019-11-01/examples/NetworkExperimentDeleteExperiment.json
            // this example is just showing the usage of "Experiments_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorExperimentResource created on azure
            // for more information of creating FrontDoorExperimentResource, please refer to the document of FrontDoorExperimentResource
            string subscriptionId = "subid";
            string resourceGroupName = "MyResourceGroup";
            string profileName = "MyProfile";
            string experimentName = "MyExperiment";
            ResourceIdentifier frontDoorExperimentResourceId = FrontDoorExperimentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, profileName, experimentName);
            FrontDoorExperimentResource frontDoorExperiment = client.GetFrontDoorExperimentResource(frontDoorExperimentResourceId);

            // invoke the operation
            await frontDoorExperiment.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Gets a Latency Scorecard for a given Experiment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetLatencyScorecardsReport_GetsALatencyScorecardForAGivenExperiment()
        {
            // Generated from example definition: specification/frontdoor/resource-manager/Microsoft.Network/stable/2019-11-01/examples/NetworkExperimentGetLatencyScorecard.json
            // this example is just showing the usage of "Reports_GetLatencyScorecards" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorExperimentResource created on azure
            // for more information of creating FrontDoorExperimentResource, please refer to the document of FrontDoorExperimentResource
            string subscriptionId = "subid";
            string resourceGroupName = "MyResourceGroup";
            string profileName = "MyProfile";
            string experimentName = "MyExperiment";
            ResourceIdentifier frontDoorExperimentResourceId = FrontDoorExperimentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, profileName, experimentName);
            FrontDoorExperimentResource frontDoorExperiment = client.GetFrontDoorExperimentResource(frontDoorExperimentResourceId);

            // invoke the operation
            LatencyScorecardAggregationInterval aggregationInterval = LatencyScorecardAggregationInterval.Daily;
            LatencyScorecard result = await frontDoorExperiment.GetLatencyScorecardsReportAsync(aggregationInterval);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Gets a Timeseries for a given Experiment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetTimeSeriesReport_GetsATimeseriesForAGivenExperiment()
        {
            // Generated from example definition: specification/frontdoor/resource-manager/Microsoft.Network/stable/2019-11-01/examples/NetworkExperimentGetTimeseries.json
            // this example is just showing the usage of "Reports_GetTimeSeries" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FrontDoorExperimentResource created on azure
            // for more information of creating FrontDoorExperimentResource, please refer to the document of FrontDoorExperimentResource
            string subscriptionId = "subid";
            string resourceGroupName = "MyResourceGroup";
            string profileName = "MyProfile";
            string experimentName = "MyExperiment";
            ResourceIdentifier frontDoorExperimentResourceId = FrontDoorExperimentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, profileName, experimentName);
            FrontDoorExperimentResource frontDoorExperiment = client.GetFrontDoorExperimentResource(frontDoorExperimentResourceId);

            // invoke the operation
            FrontDoorExperimentResourceGetTimeSeriesReportOptions options = new FrontDoorExperimentResourceGetTimeSeriesReportOptions(startOn: DateTimeOffset.Parse("2019-07-21T17:32:28Z"), endOn: DateTimeOffset.Parse("2019-09-21T17:32:28Z"), aggregationInterval: FrontDoorTimeSeriesAggregationInterval.Hourly, timeSeriesType: FrontDoorTimeSeriesType.MeasurementCounts) { };
            FrontDoorTimeSeriesInfo result = await frontDoorExperiment.GetTimeSeriesReportAsync(options);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
