// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    /// <summary> State of the selection mark. </summary>
    internal readonly partial struct V3SelectionMarkState : IEquatable<V3SelectionMarkState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="V3SelectionMarkState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public V3SelectionMarkState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SelectedValue = "selected";
        private const string UnselectedValue = "unselected";

        /// <summary> The selection mark is selected, often indicated by a check ✓ or cross X inside the selection mark. </summary>
        public static V3SelectionMarkState Selected { get; } = new V3SelectionMarkState(SelectedValue);
        /// <summary> The selection mark is not selected. </summary>
        public static V3SelectionMarkState Unselected { get; } = new V3SelectionMarkState(UnselectedValue);
        /// <summary> Determines if two <see cref="V3SelectionMarkState"/> values are the same. </summary>
        public static bool operator ==(V3SelectionMarkState left, V3SelectionMarkState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="V3SelectionMarkState"/> values are not the same. </summary>
        public static bool operator !=(V3SelectionMarkState left, V3SelectionMarkState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="V3SelectionMarkState"/>. </summary>
        public static implicit operator V3SelectionMarkState(string value) => new V3SelectionMarkState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is V3SelectionMarkState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(V3SelectionMarkState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
