// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.AI.FormRecognizer.Models;

namespace Azure.AI.FormRecognizer.Training
{
    /// <summary> Report for a custom model training document. </summary>
    public partial class TrainingDocumentInfo
    {
        /// <summary> Initializes a new instance of <see cref="TrainingDocumentInfo"/>. </summary>
        /// <param name="name"> Training document name. </param>
        /// <param name="pageCount"> Total number of pages trained. </param>
        /// <param name="errors"> List of errors. </param>
        /// <param name="status"> Status of the training operation. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="errors"/> is null. </exception>
        internal TrainingDocumentInfo(string name, int pageCount, IEnumerable<FormRecognizerError> errors, TrainingStatus status)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(errors, nameof(errors));

            Name = name;
            PageCount = pageCount;
            Errors = errors.ToList();
            Status = status;
        }

        /// <summary> Initializes a new instance of <see cref="TrainingDocumentInfo"/>. </summary>
        /// <param name="name"> Training document name. </param>
        /// <param name="pageCount"> Total number of pages trained. </param>
        /// <param name="errors"> List of errors. </param>
        /// <param name="status"> Status of the training operation. </param>
        internal TrainingDocumentInfo(string name, int pageCount, IReadOnlyList<FormRecognizerError> errors, TrainingStatus status)
        {
            Name = name;
            PageCount = pageCount;
            Errors = errors;
            Status = status;
        }
        /// <summary> List of errors. </summary>
        public IReadOnlyList<FormRecognizerError> Errors { get; }
        /// <summary> Status of the training operation. </summary>
        public TrainingStatus Status { get; }
    }
}
