// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.AI.FormRecognizer.Models
{
    public partial class TextAppearance
    {
        internal static TextAppearance DeserializeTextAppearance(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Style style = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("style"u8))
                {
                    style = FormRecognizer.Models.Style.DeserializeStyle(property.Value);
                    continue;
                }
            }
            return new TextAppearance(style);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static TextAppearance FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeTextAppearance(document.RootElement);
        }
    }
}
