// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    internal partial class ServiceResourceDetails
    {
        internal static ServiceResourceDetails DeserializeServiceResourceDetails(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            CustomDocumentModelsDetails customDocumentModels = default;
            ResourceQuotaDetails customNeuralDocumentModelBuilds = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("customDocumentModels"u8))
                {
                    customDocumentModels = CustomDocumentModelsDetails.DeserializeCustomDocumentModelsDetails(property.Value);
                    continue;
                }
                if (property.NameEquals("customNeuralDocumentModelBuilds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    customNeuralDocumentModelBuilds = ResourceQuotaDetails.DeserializeResourceQuotaDetails(property.Value);
                    continue;
                }
            }
            return new ServiceResourceDetails(customDocumentModels, customNeuralDocumentModelBuilds);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ServiceResourceDetails FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeServiceResourceDetails(document.RootElement);
        }
    }
}
