// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.FormRecognizer.Models
{
    internal partial class SelectionMark
    {
        internal static SelectionMark DeserializeSelectionMark(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<float> boundingBox = default;
            float confidence = default;
            SelectionMarkState state = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("boundingBox"u8))
                {
                    List<float> array = new List<float>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetSingle());
                    }
                    boundingBox = array;
                    continue;
                }
                if (property.NameEquals("confidence"u8))
                {
                    confidence = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    state = property.Value.GetString().ToSelectionMarkState();
                    continue;
                }
            }
            return new SelectionMark(boundingBox, confidence, state);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SelectionMark FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSelectionMark(document.RootElement);
        }
    }
}
