// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.FormRecognizer.Models
{
    internal partial class ReadResult
    {
        internal static ReadResult DeserializeReadResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int page = default;
            float angle = default;
            float width = default;
            float height = default;
            LengthUnit unit = default;
            IReadOnlyList<TextLine> lines = default;
            IReadOnlyList<SelectionMark> selectionMarks = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("page"u8))
                {
                    page = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("angle"u8))
                {
                    angle = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("width"u8))
                {
                    width = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("height"u8))
                {
                    height = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("unit"u8))
                {
                    unit = property.Value.GetString().ToLengthUnit();
                    continue;
                }
                if (property.NameEquals("lines"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<TextLine> array = new List<TextLine>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(TextLine.DeserializeTextLine(item));
                    }
                    lines = array;
                    continue;
                }
                if (property.NameEquals("selectionMarks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        selectionMarks = null;
                        continue;
                    }
                    List<SelectionMark> array = new List<SelectionMark>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SelectionMark.DeserializeSelectionMark(item));
                    }
                    selectionMarks = array;
                    continue;
                }
            }
            return new ReadResult(
                page,
                angle,
                width,
                height,
                unit,
                lines ?? new ChangeTrackingList<TextLine>(),
                selectionMarks ?? new ChangeTrackingList<SelectionMark>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ReadResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeReadResult(document.RootElement);
        }
    }
}
