// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.AI.FormRecognizer.Training;

namespace Azure.AI.FormRecognizer.Models
{
    internal partial class Models
    {
        internal static Models DeserializeModels(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ModelsSummary summary = default;
            IReadOnlyList<CustomFormModelInfo> modelList = default;
            string nextLink = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("summary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    summary = ModelsSummary.DeserializeModelsSummary(property.Value);
                    continue;
                }
                if (property.NameEquals("modelList"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CustomFormModelInfo> array = new List<CustomFormModelInfo>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CustomFormModelInfo.DeserializeCustomFormModelInfo(item));
                    }
                    modelList = array;
                    continue;
                }
                if (property.NameEquals("nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
            }
            return new Models(summary, modelList ?? new ChangeTrackingList<CustomFormModelInfo>(), nextLink);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static Models FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeModels(document.RootElement);
        }
    }
}
