// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.FormRecognizer.Models
{
    /// <summary> Semantic data type of the key value element. </summary>
    internal readonly partial struct KeyValueType : IEquatable<KeyValueType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KeyValueType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KeyValueType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StringValue = "string";
        private const string SelectionMarkValue = "selectionMark";

        /// <summary> string. </summary>
        public static KeyValueType String { get; } = new KeyValueType(StringValue);
        /// <summary> selectionMark. </summary>
        public static KeyValueType SelectionMark { get; } = new KeyValueType(SelectionMarkValue);
        /// <summary> Determines if two <see cref="KeyValueType"/> values are the same. </summary>
        public static bool operator ==(KeyValueType left, KeyValueType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KeyValueType"/> values are not the same. </summary>
        public static bool operator !=(KeyValueType left, KeyValueType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KeyValueType"/>. </summary>
        public static implicit operator KeyValueType(string value) => new KeyValueType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KeyValueType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KeyValueType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
