// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.FormRecognizer
{
    internal static partial class InternalContentTypeExtensions
    {
        public static string ToSerialString(this InternalContentType value) => value switch
        {
            InternalContentType.ApplicationOctetStream => "application/octet-stream",
            InternalContentType.ApplicationPdf => "application/pdf",
            InternalContentType.ApplicationVndOpenxmlformatsOfficedocumentPresentationmlPresentation => "application/vnd.openxmlformats-officedocument.presentationml.presentation",
            InternalContentType.ApplicationVndOpenxmlformatsOfficedocumentSpreadsheetmlSheet => "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
            InternalContentType.ApplicationVndOpenxmlformatsOfficedocumentWordprocessingmlDocument => "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
            InternalContentType.ImageBmp => "image/bmp",
            InternalContentType.ImageHeif => "image/heif",
            InternalContentType.ImageJpeg => "image/jpeg",
            InternalContentType.ImagePng => "image/png",
            InternalContentType.ImageTiff => "image/tiff",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown InternalContentType value.")
        };

        public static InternalContentType ToInternalContentType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "application/octet-stream")) return InternalContentType.ApplicationOctetStream;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "application/pdf")) return InternalContentType.ApplicationPdf;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "application/vnd.openxmlformats-officedocument.presentationml.presentation")) return InternalContentType.ApplicationVndOpenxmlformatsOfficedocumentPresentationmlPresentation;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) return InternalContentType.ApplicationVndOpenxmlformatsOfficedocumentSpreadsheetmlSheet;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "application/vnd.openxmlformats-officedocument.wordprocessingml.document")) return InternalContentType.ApplicationVndOpenxmlformatsOfficedocumentWordprocessingmlDocument;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "image/bmp")) return InternalContentType.ImageBmp;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "image/heif")) return InternalContentType.ImageHeif;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "image/jpeg")) return InternalContentType.ImageJpeg;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "image/png")) return InternalContentType.ImagePng;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "image/tiff")) return InternalContentType.ImageTiff;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown InternalContentType value.");
        }
    }
}
