// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    /// <summary> Detailed error. </summary>
    internal partial class InnerError
    {
        /// <summary> Initializes a new instance of <see cref="InnerError"/>. </summary>
        /// <param name="code"> Error code. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="code"/> is null. </exception>
        internal InnerError(string code)
        {
            Argument.AssertNotNull(code, nameof(code));

            Code = code;
        }

        /// <summary> Initializes a new instance of <see cref="InnerError"/>. </summary>
        /// <param name="code"> Error code. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="innererror"> Detailed error. </param>
        internal InnerError(string code, string message, InnerError innererror)
        {
            Code = code;
            Message = message;
            Innererror = innererror;
        }

        /// <summary> Error code. </summary>
        public string Code { get; }
        /// <summary> Error message. </summary>
        public string Message { get; }
        /// <summary> Detailed error. </summary>
        public InnerError Innererror { get; }
    }
}
