// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    /// <summary> List document classifiers response object. </summary>
    internal partial class GetDocumentClassifiersResponse
    {
        /// <summary> Initializes a new instance of <see cref="GetDocumentClassifiersResponse"/>. </summary>
        /// <param name="value"> List of document classifiers. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        internal GetDocumentClassifiersResponse(IEnumerable<DocumentClassifierDetails> value)
        {
            Argument.AssertNotNull(value, nameof(value));

            Value = value.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="GetDocumentClassifiersResponse"/>. </summary>
        /// <param name="value"> List of document classifiers. </param>
        /// <param name="nextLink"> Link to the next page of document classifiers. </param>
        internal GetDocumentClassifiersResponse(IReadOnlyList<DocumentClassifierDetails> value, Uri nextLink)
        {
            Value = value;
            NextLink = nextLink;
        }

        /// <summary> List of document classifiers. </summary>
        public IReadOnlyList<DocumentClassifierDetails> Value { get; }
        /// <summary> Link to the next page of document classifiers. </summary>
        public Uri NextLink { get; }
    }
}
