// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.FormRecognizer
{
    /// <summary> The Language. </summary>
    public readonly partial struct FormRecognizerLanguage : IEquatable<FormRecognizerLanguage>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FormRecognizerLanguage"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FormRecognizerLanguage(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AfValue = "af";
        private const string AstValue = "ast";
        private const string BiValue = "bi";
        private const string BrValue = "br";
        private const string CaValue = "ca";
        private const string CebValue = "ceb";
        private const string ChValue = "ch";
        private const string CoValue = "co";
        private const string CrhValue = "crh";
        private const string CsValue = "cs";
        private const string CsbValue = "csb";
        private const string DaValue = "da";
        private const string DeValue = "de";
        private const string EnValue = "en";
        private const string EsValue = "es";
        private const string EtValue = "et";
        private const string EuValue = "eu";
        private const string FiValue = "fi";
        private const string FilValue = "fil";
        private const string FjValue = "fj";
        private const string FrValue = "fr";
        private const string FurValue = "fur";
        private const string FyValue = "fy";
        private const string GaValue = "ga";
        private const string GdValue = "gd";
        private const string GilValue = "gil";
        private const string GlValue = "gl";
        private const string GvValue = "gv";
        private const string HniValue = "hni";
        private const string HsbValue = "hsb";
        private const string HtValue = "ht";
        private const string HuValue = "hu";
        private const string IaValue = "ia";
        private const string IdValue = "id";
        private const string ItValue = "it";
        private const string IuValue = "iu";
        private const string JaValue = "ja";
        private const string JvValue = "jv";
        private const string KaaValue = "kaa";
        private const string KacValue = "kac";
        private const string KeaValue = "kea";
        private const string KhaValue = "kha";
        private const string KlValue = "kl";
        private const string KoValue = "ko";
        private const string KuValue = "ku";
        private const string KwValue = "kw";
        private const string LbValue = "lb";
        private const string MsValue = "ms";
        private const string MwwValue = "mww";
        private const string NapValue = "nap";
        private const string NlValue = "nl";
        private const string NoValue = "no";
        private const string OcValue = "oc";
        private const string PlValue = "pl";
        private const string PtValue = "pt";
        private const string QucValue = "quc";
        private const string RmValue = "rm";
        private const string ScoValue = "sco";
        private const string SlValue = "sl";
        private const string SqValue = "sq";
        private const string SvValue = "sv";
        private const string SwValue = "sw";
        private const string TetValue = "tet";
        private const string TrValue = "tr";
        private const string TtValue = "tt";
        private const string UzValue = "uz";
        private const string VoValue = "vo";
        private const string WaeValue = "wae";
        private const string YuaValue = "yua";
        private const string ZaValue = "za";
        private const string ZhHansValue = "zh-Hans";
        private const string ZhHantValue = "zh-Hant";
        private const string ZuValue = "zu";

        /// <summary> af. </summary>
        public static FormRecognizerLanguage Af { get; } = new FormRecognizerLanguage(AfValue);
        /// <summary> ast. </summary>
        public static FormRecognizerLanguage Ast { get; } = new FormRecognizerLanguage(AstValue);
        /// <summary> bi. </summary>
        public static FormRecognizerLanguage Bi { get; } = new FormRecognizerLanguage(BiValue);
        /// <summary> br. </summary>
        public static FormRecognizerLanguage Br { get; } = new FormRecognizerLanguage(BrValue);
        /// <summary> ca. </summary>
        public static FormRecognizerLanguage Ca { get; } = new FormRecognizerLanguage(CaValue);
        /// <summary> ceb. </summary>
        public static FormRecognizerLanguage Ceb { get; } = new FormRecognizerLanguage(CebValue);
        /// <summary> ch. </summary>
        public static FormRecognizerLanguage Ch { get; } = new FormRecognizerLanguage(ChValue);
        /// <summary> co. </summary>
        public static FormRecognizerLanguage Co { get; } = new FormRecognizerLanguage(CoValue);
        /// <summary> crh. </summary>
        public static FormRecognizerLanguage Crh { get; } = new FormRecognizerLanguage(CrhValue);
        /// <summary> cs. </summary>
        public static FormRecognizerLanguage Cs { get; } = new FormRecognizerLanguage(CsValue);
        /// <summary> csb. </summary>
        public static FormRecognizerLanguage Csb { get; } = new FormRecognizerLanguage(CsbValue);
        /// <summary> da. </summary>
        public static FormRecognizerLanguage Da { get; } = new FormRecognizerLanguage(DaValue);
        /// <summary> de. </summary>
        public static FormRecognizerLanguage De { get; } = new FormRecognizerLanguage(DeValue);
        /// <summary> en. </summary>
        public static FormRecognizerLanguage En { get; } = new FormRecognizerLanguage(EnValue);
        /// <summary> es. </summary>
        public static FormRecognizerLanguage Es { get; } = new FormRecognizerLanguage(EsValue);
        /// <summary> et. </summary>
        public static FormRecognizerLanguage Et { get; } = new FormRecognizerLanguage(EtValue);
        /// <summary> eu. </summary>
        public static FormRecognizerLanguage Eu { get; } = new FormRecognizerLanguage(EuValue);
        /// <summary> fi. </summary>
        public static FormRecognizerLanguage Fi { get; } = new FormRecognizerLanguage(FiValue);
        /// <summary> fil. </summary>
        public static FormRecognizerLanguage Fil { get; } = new FormRecognizerLanguage(FilValue);
        /// <summary> fj. </summary>
        public static FormRecognizerLanguage Fj { get; } = new FormRecognizerLanguage(FjValue);
        /// <summary> fr. </summary>
        public static FormRecognizerLanguage Fr { get; } = new FormRecognizerLanguage(FrValue);
        /// <summary> fur. </summary>
        public static FormRecognizerLanguage Fur { get; } = new FormRecognizerLanguage(FurValue);
        /// <summary> fy. </summary>
        public static FormRecognizerLanguage Fy { get; } = new FormRecognizerLanguage(FyValue);
        /// <summary> ga. </summary>
        public static FormRecognizerLanguage Ga { get; } = new FormRecognizerLanguage(GaValue);
        /// <summary> gd. </summary>
        public static FormRecognizerLanguage Gd { get; } = new FormRecognizerLanguage(GdValue);
        /// <summary> gil. </summary>
        public static FormRecognizerLanguage Gil { get; } = new FormRecognizerLanguage(GilValue);
        /// <summary> gl. </summary>
        public static FormRecognizerLanguage Gl { get; } = new FormRecognizerLanguage(GlValue);
        /// <summary> gv. </summary>
        public static FormRecognizerLanguage Gv { get; } = new FormRecognizerLanguage(GvValue);
        /// <summary> hni. </summary>
        public static FormRecognizerLanguage Hni { get; } = new FormRecognizerLanguage(HniValue);
        /// <summary> hsb. </summary>
        public static FormRecognizerLanguage Hsb { get; } = new FormRecognizerLanguage(HsbValue);
        /// <summary> ht. </summary>
        public static FormRecognizerLanguage Ht { get; } = new FormRecognizerLanguage(HtValue);
        /// <summary> hu. </summary>
        public static FormRecognizerLanguage Hu { get; } = new FormRecognizerLanguage(HuValue);
        /// <summary> ia. </summary>
        public static FormRecognizerLanguage Ia { get; } = new FormRecognizerLanguage(IaValue);
        /// <summary> id. </summary>
        public static FormRecognizerLanguage Id { get; } = new FormRecognizerLanguage(IdValue);
        /// <summary> it. </summary>
        public static FormRecognizerLanguage It { get; } = new FormRecognizerLanguage(ItValue);
        /// <summary> iu. </summary>
        public static FormRecognizerLanguage Iu { get; } = new FormRecognizerLanguage(IuValue);
        /// <summary> ja. </summary>
        public static FormRecognizerLanguage Ja { get; } = new FormRecognizerLanguage(JaValue);
        /// <summary> jv. </summary>
        public static FormRecognizerLanguage Jv { get; } = new FormRecognizerLanguage(JvValue);
        /// <summary> kaa. </summary>
        public static FormRecognizerLanguage Kaa { get; } = new FormRecognizerLanguage(KaaValue);
        /// <summary> kac. </summary>
        public static FormRecognizerLanguage Kac { get; } = new FormRecognizerLanguage(KacValue);
        /// <summary> kea. </summary>
        public static FormRecognizerLanguage Kea { get; } = new FormRecognizerLanguage(KeaValue);
        /// <summary> kha. </summary>
        public static FormRecognizerLanguage Kha { get; } = new FormRecognizerLanguage(KhaValue);
        /// <summary> kl. </summary>
        public static FormRecognizerLanguage Kl { get; } = new FormRecognizerLanguage(KlValue);
        /// <summary> ko. </summary>
        public static FormRecognizerLanguage Ko { get; } = new FormRecognizerLanguage(KoValue);
        /// <summary> ku. </summary>
        public static FormRecognizerLanguage Ku { get; } = new FormRecognizerLanguage(KuValue);
        /// <summary> kw. </summary>
        public static FormRecognizerLanguage Kw { get; } = new FormRecognizerLanguage(KwValue);
        /// <summary> lb. </summary>
        public static FormRecognizerLanguage Lb { get; } = new FormRecognizerLanguage(LbValue);
        /// <summary> ms. </summary>
        public static FormRecognizerLanguage Ms { get; } = new FormRecognizerLanguage(MsValue);
        /// <summary> mww. </summary>
        public static FormRecognizerLanguage Mww { get; } = new FormRecognizerLanguage(MwwValue);
        /// <summary> nap. </summary>
        public static FormRecognizerLanguage Nap { get; } = new FormRecognizerLanguage(NapValue);
        /// <summary> nl. </summary>
        public static FormRecognizerLanguage Nl { get; } = new FormRecognizerLanguage(NlValue);
        /// <summary> no. </summary>
        public static FormRecognizerLanguage No { get; } = new FormRecognizerLanguage(NoValue);
        /// <summary> oc. </summary>
        public static FormRecognizerLanguage Oc { get; } = new FormRecognizerLanguage(OcValue);
        /// <summary> pl. </summary>
        public static FormRecognizerLanguage Pl { get; } = new FormRecognizerLanguage(PlValue);
        /// <summary> pt. </summary>
        public static FormRecognizerLanguage Pt { get; } = new FormRecognizerLanguage(PtValue);
        /// <summary> quc. </summary>
        public static FormRecognizerLanguage Quc { get; } = new FormRecognizerLanguage(QucValue);
        /// <summary> rm. </summary>
        public static FormRecognizerLanguage Rm { get; } = new FormRecognizerLanguage(RmValue);
        /// <summary> sco. </summary>
        public static FormRecognizerLanguage Sco { get; } = new FormRecognizerLanguage(ScoValue);
        /// <summary> sl. </summary>
        public static FormRecognizerLanguage Sl { get; } = new FormRecognizerLanguage(SlValue);
        /// <summary> sq. </summary>
        public static FormRecognizerLanguage Sq { get; } = new FormRecognizerLanguage(SqValue);
        /// <summary> sv. </summary>
        public static FormRecognizerLanguage Sv { get; } = new FormRecognizerLanguage(SvValue);
        /// <summary> sw. </summary>
        public static FormRecognizerLanguage Sw { get; } = new FormRecognizerLanguage(SwValue);
        /// <summary> tet. </summary>
        public static FormRecognizerLanguage Tet { get; } = new FormRecognizerLanguage(TetValue);
        /// <summary> tr. </summary>
        public static FormRecognizerLanguage Tr { get; } = new FormRecognizerLanguage(TrValue);
        /// <summary> tt. </summary>
        public static FormRecognizerLanguage Tt { get; } = new FormRecognizerLanguage(TtValue);
        /// <summary> uz. </summary>
        public static FormRecognizerLanguage Uz { get; } = new FormRecognizerLanguage(UzValue);
        /// <summary> vo. </summary>
        public static FormRecognizerLanguage Vo { get; } = new FormRecognizerLanguage(VoValue);
        /// <summary> wae. </summary>
        public static FormRecognizerLanguage Wae { get; } = new FormRecognizerLanguage(WaeValue);
        /// <summary> yua. </summary>
        public static FormRecognizerLanguage Yua { get; } = new FormRecognizerLanguage(YuaValue);
        /// <summary> za. </summary>
        public static FormRecognizerLanguage Za { get; } = new FormRecognizerLanguage(ZaValue);
        /// <summary> zh-Hans. </summary>
        public static FormRecognizerLanguage ZhHans { get; } = new FormRecognizerLanguage(ZhHansValue);
        /// <summary> zh-Hant. </summary>
        public static FormRecognizerLanguage ZhHant { get; } = new FormRecognizerLanguage(ZhHantValue);
        /// <summary> zu. </summary>
        public static FormRecognizerLanguage Zu { get; } = new FormRecognizerLanguage(ZuValue);
        /// <summary> Determines if two <see cref="FormRecognizerLanguage"/> values are the same. </summary>
        public static bool operator ==(FormRecognizerLanguage left, FormRecognizerLanguage right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FormRecognizerLanguage"/> values are not the same. </summary>
        public static bool operator !=(FormRecognizerLanguage left, FormRecognizerLanguage right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FormRecognizerLanguage"/>. </summary>
        public static implicit operator FormRecognizerLanguage(string value) => new FormRecognizerLanguage(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FormRecognizerLanguage other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FormRecognizerLanguage other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
