// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.FormRecognizer
{
    internal static partial class FormReadingOrderExtensions
    {
        public static string ToSerialString(this FormReadingOrder value) => value switch
        {
            FormReadingOrder.Basic => "basic",
            FormReadingOrder.Natural => "natural",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FormReadingOrder value.")
        };

        public static FormReadingOrder ToFormReadingOrder(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "basic")) return FormReadingOrder.Basic;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "natural")) return FormReadingOrder.Natural;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FormReadingOrder value.");
        }
    }
}
