// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.FormRecognizer.Models
{
    internal static partial class FieldValueTypeExtensions
    {
        public static string ToSerialString(this FieldValueType value) => value switch
        {
            FieldValueType.String => "string",
            FieldValueType.Date => "date",
            FieldValueType.Time => "time",
            FieldValueType.PhoneNumber => "phoneNumber",
            FieldValueType.Float => "number",
            FieldValueType.Int64 => "integer",
            FieldValueType.List => "array",
            FieldValueType.Dictionary => "object",
            FieldValueType.SelectionMark => "selectionMark",
            FieldValueType.CountryRegion => "countryRegion",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FieldValueType value.")
        };

        public static FieldValueType ToFieldValueType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "string")) return FieldValueType.String;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "date")) return FieldValueType.Date;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "time")) return FieldValueType.Time;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "phoneNumber")) return FieldValueType.PhoneNumber;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "number")) return FieldValueType.Float;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "integer")) return FieldValueType.Int64;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "array")) return FieldValueType.List;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "object")) return FieldValueType.Dictionary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "selectionMark")) return FieldValueType.SelectionMark;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "countryRegion")) return FieldValueType.CountryRegion;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown FieldValueType value.");
        }
    }
}
