// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.FormRecognizer.Models
{
    /// <summary> Selection mark value. </summary>
    internal readonly partial struct FieldValueSelectionMark : IEquatable<FieldValueSelectionMark>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FieldValueSelectionMark"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FieldValueSelectionMark(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SelectedValue = "selected";
        private const string UnselectedValue = "unselected";

        /// <summary> selected. </summary>
        public static FieldValueSelectionMark Selected { get; } = new FieldValueSelectionMark(SelectedValue);
        /// <summary> unselected. </summary>
        public static FieldValueSelectionMark Unselected { get; } = new FieldValueSelectionMark(UnselectedValue);
        /// <summary> Determines if two <see cref="FieldValueSelectionMark"/> values are the same. </summary>
        public static bool operator ==(FieldValueSelectionMark left, FieldValueSelectionMark right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FieldValueSelectionMark"/> values are not the same. </summary>
        public static bool operator !=(FieldValueSelectionMark left, FieldValueSelectionMark right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FieldValueSelectionMark"/>. </summary>
        public static implicit operator FieldValueSelectionMark(string value) => new FieldValueSelectionMark(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FieldValueSelectionMark other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FieldValueSelectionMark other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
