// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    /// <summary> Document type info. </summary>
    public partial class DocumentTypeDetails
    {
        /// <summary> Initializes a new instance of <see cref="DocumentTypeDetails"/>. </summary>
        /// <param name="fieldSchema"> Description of the document semantic schema using a JSON Schema style syntax. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="fieldSchema"/> is null. </exception>
        internal DocumentTypeDetails(IReadOnlyDictionary<string, DocumentFieldSchema> fieldSchema)
        {
            Argument.AssertNotNull(fieldSchema, nameof(fieldSchema));

            FieldSchema = fieldSchema;
            FieldConfidence = new ChangeTrackingDictionary<string, float>();
        }

        /// <summary> Initializes a new instance of <see cref="DocumentTypeDetails"/>. </summary>
        /// <param name="description"> Document model description. </param>
        /// <param name="buildMode"> Custom document model build mode. </param>
        /// <param name="fieldSchema"> Description of the document semantic schema using a JSON Schema style syntax. </param>
        /// <param name="fieldConfidence"> Estimated confidence for each field. </param>
        internal DocumentTypeDetails(string description, DocumentBuildMode? buildMode, IReadOnlyDictionary<string, DocumentFieldSchema> fieldSchema, IReadOnlyDictionary<string, float> fieldConfidence)
        {
            Description = description;
            BuildMode = buildMode;
            FieldSchema = fieldSchema;
            FieldConfidence = fieldConfidence;
        }

        /// <summary> Document model description. </summary>
        public string Description { get; }
        /// <summary> Custom document model build mode. </summary>
        public DocumentBuildMode? BuildMode { get; }
        /// <summary> Estimated confidence for each field. </summary>
        public IReadOnlyDictionary<string, float> FieldConfidence { get; }
    }
}
