// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    /// <summary> An object representing the location and content of a table cell. </summary>
    public partial class DocumentTableCell
    {
        /// <summary> Initializes a new instance of <see cref="DocumentTableCell"/>. </summary>
        /// <param name="rowIndex"> Row index of the cell. </param>
        /// <param name="columnIndex"> Column index of the cell. </param>
        /// <param name="content"> Concatenated content of the table cell in reading order. </param>
        /// <param name="spans"> Location of the table cell in the reading order concatenated content. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> or <paramref name="spans"/> is null. </exception>
        internal DocumentTableCell(int rowIndex, int columnIndex, string content, IEnumerable<DocumentSpan> spans)
        {
            Argument.AssertNotNull(content, nameof(content));
            Argument.AssertNotNull(spans, nameof(spans));

            RowIndex = rowIndex;
            ColumnIndex = columnIndex;
            Content = content;
            BoundingRegions = new ChangeTrackingList<BoundingRegion>();
            Spans = spans.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="DocumentTableCell"/>. </summary>
        /// <param name="kindPrivate"> Table cell kind. </param>
        /// <param name="rowIndex"> Row index of the cell. </param>
        /// <param name="columnIndex"> Column index of the cell. </param>
        /// <param name="rowSpanPrivate"> Number of rows spanned by this cell. </param>
        /// <param name="columnSpanPrivate"> Number of columns spanned by this cell. </param>
        /// <param name="content"> Concatenated content of the table cell in reading order. </param>
        /// <param name="boundingRegions"> Bounding regions covering the table cell. </param>
        /// <param name="spans"> Location of the table cell in the reading order concatenated content. </param>
        internal DocumentTableCell(DocumentTableCellKind? kindPrivate, int rowIndex, int columnIndex, int? rowSpanPrivate, int? columnSpanPrivate, string content, IReadOnlyList<BoundingRegion> boundingRegions, IReadOnlyList<DocumentSpan> spans)
        {
            KindPrivate = kindPrivate;
            RowIndex = rowIndex;
            ColumnIndex = columnIndex;
            RowSpanPrivate = rowSpanPrivate;
            ColumnSpanPrivate = columnSpanPrivate;
            Content = content;
            BoundingRegions = boundingRegions;
            Spans = spans;
        }
        /// <summary> Row index of the cell. </summary>
        public int RowIndex { get; }
        /// <summary> Column index of the cell. </summary>
        public int ColumnIndex { get; }
        /// <summary> Concatenated content of the table cell in reading order. </summary>
        public string Content { get; }
        /// <summary> Bounding regions covering the table cell. </summary>
        public IReadOnlyList<BoundingRegion> BoundingRegions { get; }
        /// <summary> Location of the table cell in the reading order concatenated content. </summary>
        public IReadOnlyList<DocumentSpan> Spans { get; }
    }
}
