// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    public partial class DocumentStyle
    {
        internal static DocumentStyle DeserializeDocumentStyle(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? isHandwritten = default;
            string similarFontFamily = default;
            DocumentFontStyle? fontStyle = default;
            DocumentFontWeight? fontWeight = default;
            string color = default;
            string backgroundColor = default;
            IReadOnlyList<DocumentSpan> spans = default;
            float confidence = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("isHandwritten"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isHandwritten = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("similarFontFamily"u8))
                {
                    similarFontFamily = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fontStyle"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fontStyle = new DocumentFontStyle(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("fontWeight"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fontWeight = new DocumentFontWeight(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("color"u8))
                {
                    color = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("backgroundColor"u8))
                {
                    backgroundColor = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("spans"u8))
                {
                    List<DocumentSpan> array = new List<DocumentSpan>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DocumentSpan.DeserializeDocumentSpan(item));
                    }
                    spans = array;
                    continue;
                }
                if (property.NameEquals("confidence"u8))
                {
                    confidence = property.Value.GetSingle();
                    continue;
                }
            }
            return new DocumentStyle(
                isHandwritten,
                similarFontFamily,
                fontStyle,
                fontWeight,
                color,
                backgroundColor,
                spans,
                confidence);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DocumentStyle FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDocumentStyle(document.RootElement);
        }
    }
}
