// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    /// <summary> Content and layout elements extracted from a page from the input. </summary>
    public partial class DocumentPage
    {
        /// <summary> Initializes a new instance of <see cref="DocumentPage"/>. </summary>
        /// <param name="pageNumber"> 1-based page number in the input document. </param>
        /// <param name="spans"> Location of the page in the reading order concatenated content. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="spans"/> is null. </exception>
        internal DocumentPage(int pageNumber, IEnumerable<DocumentSpan> spans)
        {
            Argument.AssertNotNull(spans, nameof(spans));

            PageNumber = pageNumber;
            Spans = spans.ToList();
            Words = new ChangeTrackingList<DocumentWord>();
            SelectionMarks = new ChangeTrackingList<DocumentSelectionMark>();
            Lines = new ChangeTrackingList<DocumentLine>();
            Barcodes = new ChangeTrackingList<DocumentBarcode>();
            Formulas = new ChangeTrackingList<DocumentFormula>();
        }

        /// <summary> 1-based page number in the input document. </summary>
        public int PageNumber { get; }
        /// <summary> The general orientation of the content in clockwise direction, measured in degrees between (-180, 180]. </summary>
        public float? Angle { get; }
        /// <summary> The width of the image/PDF in pixels/inches, respectively. </summary>
        public float? Width { get; }
        /// <summary> The height of the image/PDF in pixels/inches, respectively. </summary>
        public float? Height { get; }
        /// <summary> Location of the page in the reading order concatenated content. </summary>
        public IReadOnlyList<DocumentSpan> Spans { get; }
        /// <summary> Extracted words from the page. </summary>
        public IReadOnlyList<DocumentWord> Words { get; }
        /// <summary> Extracted selection marks from the page. </summary>
        public IReadOnlyList<DocumentSelectionMark> SelectionMarks { get; }
        /// <summary> Extracted lines from the page, potentially containing both textual and visual elements. </summary>
        public IReadOnlyList<DocumentLine> Lines { get; }
        /// <summary> Extracted barcodes from the page. </summary>
        public IReadOnlyList<DocumentBarcode> Barcodes { get; }
        /// <summary> Extracted formulas from the page. </summary>
        public IReadOnlyList<DocumentFormula> Formulas { get; }
    }
}
