// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    internal static partial class DocumentOperationStatusExtensions
    {
        public static string ToSerialString(this DocumentOperationStatus value) => value switch
        {
            DocumentOperationStatus.NotStarted => "notStarted",
            DocumentOperationStatus.Running => "running",
            DocumentOperationStatus.Failed => "failed",
            DocumentOperationStatus.Succeeded => "succeeded",
            DocumentOperationStatus.Canceled => "canceled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DocumentOperationStatus value.")
        };

        public static DocumentOperationStatus ToDocumentOperationStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "notStarted")) return DocumentOperationStatus.NotStarted;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "running")) return DocumentOperationStatus.Running;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "failed")) return DocumentOperationStatus.Failed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "succeeded")) return DocumentOperationStatus.Succeeded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "canceled")) return DocumentOperationStatus.Canceled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DocumentOperationStatus value.");
        }
    }
}
