// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    /// <summary> A content line object consisting of an adjacent sequence of content elements, such as words and selection marks. </summary>
    public partial class DocumentLine
    {
        /// <summary> Initializes a new instance of <see cref="DocumentLine"/>. </summary>
        /// <param name="content"> Concatenated content of the contained elements in reading order. </param>
        /// <param name="spans"> Location of the line in the reading order concatenated content. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> or <paramref name="spans"/> is null. </exception>
        internal DocumentLine(string content, IEnumerable<DocumentSpan> spans)
        {
            Argument.AssertNotNull(content, nameof(content));
            Argument.AssertNotNull(spans, nameof(spans));

            Content = content;
            Polygon = new ChangeTrackingList<float>();
            Spans = spans.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="DocumentLine"/>. </summary>
        /// <param name="content"> Concatenated content of the contained elements in reading order. </param>
        /// <param name="polygon"> Bounding polygon of the line. </param>
        /// <param name="spans"> Location of the line in the reading order concatenated content. </param>
        internal DocumentLine(string content, IReadOnlyList<float> polygon, IReadOnlyList<DocumentSpan> spans)
        {
            Content = content;
            Polygon = polygon;
            Spans = spans;
        }

        /// <summary> Concatenated content of the contained elements in reading order. </summary>
        public string Content { get; }
        /// <summary> Location of the line in the reading order concatenated content. </summary>
        public IReadOnlyList<DocumentSpan> Spans { get; }
    }
}
