// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.FormRecognizer.DocumentAnalysis
{
    /// <summary> Formula kind. </summary>
    public readonly partial struct DocumentFormulaKind : IEquatable<DocumentFormulaKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DocumentFormulaKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DocumentFormulaKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InlineValue = "inline";
        private const string DisplayValue = "display";

        /// <summary> A formula embedded within the content of a paragraph. </summary>
        public static DocumentFormulaKind Inline { get; } = new DocumentFormulaKind(InlineValue);
        /// <summary> A formula in display mode that takes up an entire line. </summary>
        public static DocumentFormulaKind Display { get; } = new DocumentFormulaKind(DisplayValue);
        /// <summary> Determines if two <see cref="DocumentFormulaKind"/> values are the same. </summary>
        public static bool operator ==(DocumentFormulaKind left, DocumentFormulaKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DocumentFormulaKind"/> values are not the same. </summary>
        public static bool operator !=(DocumentFormulaKind left, DocumentFormulaKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DocumentFormulaKind"/>. </summary>
        public static implicit operator DocumentFormulaKind(string value) => new DocumentFormulaKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DocumentFormulaKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DocumentFormulaKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
